/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.event.extensions.sip;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;


/**
 * Listener interface to handle sip container events.
 *
 */
public interface SipContainerEventListener extends AdminEventListener {
    /**
     * Handles sip-container element/attribute removal.
     * It is called whenever a SipContainerEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleDelete(SipContainerEvent event)
        throws AdminEventListenerException;

    /**
     * Handles sip-container element/attribute modification.
     * It is called whenever a SipContainerEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleUpdate(SipContainerEvent event)
        throws AdminEventListenerException;

    /**
     * Handles sip-container element/attribute creation.
     * It is called whenever a SipContainerEvent is received.
     *
     * @param event                        Event to be processed.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void handleCreate(SipContainerEvent event)
        throws AdminEventListenerException;
}
