

function checkCLBSelectedAllTargets(targetSectionID) {
    selectedField = getSelectedAddRemoveField(targetSectionID);
    if (selectedField) {
        if (selectedField.options.length == 1) {
            var msg1 = "You have selected to delete the CLB from all the targets." + '\n' + 
                "This will also delete the CLB. Continue?";
            return confirm(msg1);
        }
    }
    return true;
}

function checkSelfLB(targetSectionID, selfLBID) {
    selected = getSelectedAddRemoveField(targetSectionID);
    if(selected) {
        selOptions = selected.options.length - 1;
        if(selOptions > 1) {
            // self LB should be false for this case
            selfLB = doucment.getElementById(selfLBID).checked;
            if(selfLB) {
                msg = "You cannot select more than one target for a Self Load Balancing CLB" + '\n' + 
                        "Please select only one target or make sure Self Load Balancing is unchecked";
                alert(msg);
                return false;
            }
        }
    }
    return true;
}

function getSelectedAddRemoveField(targetSectionID) {
    selectFieldName = targetSectionID + ":commonAddRemove_selected";
    selectedField = document.getElementById(selectFieldName);
    return selectedField;
}