<!--
 DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 
 Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 
 The contents of this file are subject to the terms of either the GNU
 General Public License Version 2 only ("GPL") or the Common Development
 and Distribution License("CDDL") (collectively, the "License").  You
 may not use this file except in compliance with the License. You can obtain
 a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 language governing permissions and limitations under the License.
 
 When distributing the software, include this License Header Notice in each
 file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 Sun designates this particular file as subject to the "Classpath" exception
 as provided by Sun in the GPL Version 2 section of the License file that
 accompanied this code.  If applicable, add the following below the License
 Header, with the fields enclosed by brackets [] replaced by your own
 identifying information: "Portions Copyrighted [year]
 [name of copyright owner]"
 
 Contributor(s):
 
 If you wish your version of this file to be governed by only the CDDL or
 only the GPL Version 2, indicate your decision by adding "[Contributor]
 elects to include this software in this distribution under the [CDDL or GPL
 Version 2] license."  If you don't indicate a single choice of license, a
 recipient has the option to distribute your version of this file under
 either the CDDL, the GPL Version 2 or to extend the choice of license to
 its licensees as provided above.  However, if you add GPL Version 2 code
 and therefore, elected the GPL Version 2 license, then the option applies
 only if the new code is made subject to such option by the copyright
 holder.
-->
<!-- sip/configuration/sipListener.inc -->    
<!-- Page Title -->
<sun:title id="propertyContentPage" title="#{pageTitle}" helpText="#{pageTitleHelp}">
    <!facet pageButtonsTop>
    <sun:panelGroup id="topButtons">
        <sun:button id="saveButton" rendered="#{edit}" text="$resource{i18n.button.Save}" 
        onClick="return guiValidateWithDropDown('#{reqMsg}','#{reqInt}' ,'#{reqPort}', '#{reqMsgSelect}');" >   
            <!command
            getUIComponent(clientId="$pageSession{propertyTableRowGroupId}", component=>$attribute{tableRowGroup});
            getAllSingleMapRows(TableRowGroup="$attribute{tableRowGroup}",  Rows=>$attribute{newList});
            convertListToArrayList(TableList="#{newList}", NameList=>$attribute{nameList});
            getAddRemoveProps(NewList="#{newList}", OldList="#{props}", NameList="#{nameList}", AddProps=>$attribute{addProps}, RemoveProps=>$attribute{removeProps});
            prepareSuccessfulMsg();   
            saveSipListenerValues(
            ConfigName="#{configName}"
            SipName="#{tabName}"  
            Edit="#{edit}"
            Address="#{address}" 
            Port="#{port}"
            Listener="#{listener}"
            Transport="#{transport}"
            AddProps="#{addProps}"
            RemoveProps="#{removeProps}"
            );
           redirect(page="#{editPage}?alertType=${alertType}&alertSummary=${alertSummary}&alertDetail=${alertDetail}&configName=#{configName}&name=#{tabName}");
            />
        </sun:button>
        <sun:button id="nextButton" rendered="#{!edit}" text="$resource{i18n.button.Next}" 
                onClick="return guiValidateWithDropDown('#{reqMsg}','#{reqInt}' ,'#{reqPort}', '#{reqMsgSelect}');" > 
            <!command
            getUIComponent(clientId="$pageSession{propertyTableRowGroupId}", component=>$attribute{tableRowGroup});
            getAllSingleMapRows(TableRowGroup="$attribute{tableRowGroup}",  Rows=>$attribute{newList});
            convertRowsToProperties(NewList="#{newList}", AddProps=>$attribute{addProps});
            saveSipListenerValues(
            ConfigName="#{configName}"
            SipName="#{tabName}"  
            Edit="#{edit}"
            Address="#{address}" 
            Port="#{port}"
            Listener="#{listener}"
            Transport="#{transport}"
            AddProps="#{addProps}"
            RemoveProps="#{removeProps}"
            );           
            setAttribute(key="configName", value="#{configName}");
            setAttribute(key="tabName", value="#{tabName}");
            setAttribute(key="type", value="sip");
            setAttribute(key="sslPageTitle", value="#{step2PageTitle}");
            setAttribute(key="prevPage", value="/sip/configuration/sipListenerNew.jsf");
            setAttribute(key="finalPage", value="sipListeners.jsf");
            setAttribute(key="ssl2", value="#{true}");
            navigate(page="/sip/configuration/sipListenersSslNew.jsf");
            />
        </sun:button>
        <sun:button id="cancelButton" rendered="#{!edit}" immediate="#{true}" text="$resource{i18n.button.Cancel}" primary="#{false}">
            <!command
            setSessionAttribute(key="sipProps" value="#{null}")
            setSessionAttribute(key="sslProps" value="#{null}")
            redirect(page="sipListeners.jsf?configName=#{configName}");
            />
        </sun:button>
        
    </sun:panelGroup>
    </facet>   
</sun:title>
<!-- PropertySheet .... -->
<sun:propertySheet id="propertySheet">			 
        <event>
            <!beforeCreate
            getSipListenerTransportProtocols(ConfigName="#{configName}", Protocols=>$attribute{protocols});
            getSipListenerValues(Edit="#{edit}", FromStep2="#{fromStep2}", ConfigName="#{configName}", 
            SipName="#{tabName}", Listener=>$attribute{listener}, 
            Address=>$attribute{address}, Port=>$attribute{port}, 
            Transport=>$attribute{transport}, Properties=>$page{props});
            getTableList(Properties="#{props}", TableList=>$attribute{tableList});
            />
        </event>

        <!-- General Settings section -->   
        <sun:propertySheetSection id="generalSettingsSetion" label="$resource{i18n.common.GeneralSettings}">
            <sun:property id="SipNameProp"  rendered="#{edit}" labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.common.Name}" >
                <sun:staticText id="SipNameName" text="#{tabName}" /> 
            </sun:property> 
            <sun:property id="SipNameTextProp"  rendered="#{!edit}" labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.common.Name}">
                <sun:textField id="SipNameText" styleClass="required" text="#{tabName}" columns="$int{55}" required="#{true}" /> 
            </sun:property> 
            <sun:property id="ListenerProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.iiopListener.listenerLabel}" >
                <sun:checkbox label="$resource{i18n.desc.Enabled}" selected="#{requestScope.listener}" />   
            </sun:property>
            <sun:property id="AddressProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.iiopListener.netwkAddrLabel}" helpText="$resource{i18n.httpListeners.netwkAddrHelp}" >
                <sun:textField id="Address" styleClass="require" columns="$int{20}" text="#{requestScope.address}" required="#{true}" />      
            </sun:property> 
            <sun:property id="ListenerPortProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.iiopListener.listPortLabel}" helpText="$resource{i18n.httpListeners.listPortHelp}" >
                <sun:textField id="Port" styleClass="require port" columns="$int{20}" text="#{requestScope.port}" required="#{true}" />      
            </sun:property> 
            <sun:property id="TransportProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{sip.sipListeners.edit.transportLabel}" helpText="$resource{sip.sipListeners.edit.transportHelp}">
                <sun:dropDown id="Transport" styleClass="require" selected="#{requestScope.transport}" items="$attribute{protocols}" required="#{true}"/>
            </sun:property>                          
        </sun:propertySheetSection>                            
</sun:propertySheet>    

