/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */


package org.jvnet.glassfish.comms.admin.gui.extensions.handlers;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipSecurityHelper;

/**
 *
 * @author irfan@sun.com
 */
public class SecurityHandlers {
    
    @Handler(id="getTrustedConfigsList",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="result", type=List.class)
    })
    public static void getTrustedConfigsList(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        ArrayList result = new ArrayList();
        try {
            List<ObjectName> trustConfigs = SipSecurityHelper.getTrustConfigs(configName);
            for (ObjectName trustConfig : trustConfigs) {
                String name = trustConfig.getKeyProperty("id");
                String trustConfigType = SipSecurityHelper.getTrustConfigType(trustConfig);
                HashMap oneRow = new HashMap();
                oneRow.put("name", name);
                oneRow.put("type", trustConfigType);
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("result", result);
    }
    
    @Handler(id="intializeTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class)
    })
    public static void intializeTrustConfig(HandlerContext handlerContext) {
        HashMap map = new HashMap();
        map.put("trustTypeOption", "entity");
        map.put("default", false);
        handlerContext.setOutputValue("attrMap", map);
    }
    
    @Handler(id="createTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="trustTypeOption", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class, required=true),
        @HandlerInput(name="handlerProps", type=Map.class, required=true)
    })
    public static void createTrustConfig(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        try {
            attrMap.put("trustTypeOption", (String) handlerContext.getInputValue("trustTypeOption"));
            attrMap.put("handlerProps", (HashMap) handlerContext.getInputValue("handlerProps"));
            SipSecurityHelper.createTrustConfig(configName, attrMap);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="deleteTrustConfig",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="selectedRows", type=List.class)
    })
    public static void deleteTrustConfig(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        List<Map> rows = (List) handlerContext.getInputValue("selectedRows");
        try {
            for (Map oneRow : rows) {
                String id = (String) oneRow.get("name");
                SipSecurityHelper.deleteTrustConfig(configName, id);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
            
    }
}
