/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.util;

import com.sun.enterprise.tools.admingui.util.JMXUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;


/**
 *
 * @author irfan
 */
public class SipSecurityHelper {
    /** This represents the security-service per config. You need to supply ,config=<config-name> */
    public static final String CONFIG_SECURITY_SERVICE_OBJECTNAME = 
            "com.sun.appserv:type=security-service,category=config";
    
    public static ObjectName getSecurityServiceObject(String configName) throws Exception{
        String secServiceObjectName = CONFIG_SECURITY_SERVICE_OBJECTNAME + ",config=" + configName;
        return new ObjectName(secServiceObjectName);
    }

    public static List getTrustConfigs(String configName) throws Exception{
        ObjectName secService = getSecurityServiceObject(configName);
        ObjectName[] trustConfigs = (ObjectName[]) SipUtil.getChildByFunction(secService, 
                "getIdentityAssertionTrust", null, null);
        if(trustConfigs != null) {
            return Arrays.asList(trustConfigs);
        } else {
            return null;
        }
        
    }

    public static String getTrustConfigType(ObjectName trustConfig) throws Exception{
        String type = "Trust Entities";
        ObjectName[] entities = (ObjectName[]) SipUtil.getChildByFunction(trustConfig, "getTrustedEntity");
        if((entities == null) || (entities.length == 0)) {
            ObjectName trustHandler = (ObjectName) SipUtil.getChildByFunction(trustConfig, 
                    "getTrustHandler");
            if(trustHandler != null) {
                type = "Trust Handler";
            }
        }
        return type;
    }

    public static void createTrustConfig(String configName, HashMap map) throws Exception{
        // create the attr list
        HashMap attrMap  = new HashMap();
        attrMap.put("id", (String) map.get("name"));
        attrMap.put("is-default", map.get("default").toString());
        AttributeList attrList = SipUtil.convertMapToAttributeList(attrMap);
        
        String selected = (String) map.get("trustTypeOption");
        AttributeList entityList = new AttributeList();
        Properties handlerProps = new Properties();
        
        if("entity".equals(selected)) {
            attrMap.clear();
            attrMap.put("id", (String) map.get("entityName"));
            attrMap.put("trusted-as", (String) map.get("entityTrustedAs"));
            attrMap.put("ip-address", (String) map.get("entityIPAddress"));
            attrMap.put("domain-name", (String) map.get("entityDomainName"));
            attrMap.put("principal", (String) map.get("entityPrincipal"));
            entityList = SipUtil.convertMapToAttributeList(attrMap);
        } else {
            //trust handler
            String className = (String) map.get("handlerClassName");
            Attribute handlerClassNameAttr = new Attribute("class-name", className);
            attrList.add(handlerClassNameAttr);
            HashMap newProps = (HashMap) map.get("handlerProps");
            if ((newProps != null) && (newProps.size() > 0)) {
                handlerProps.putAll(newProps);
            } else {
                newProps = null;
            }
        }
        
        ObjectName sipConfigsObject = SipUtil.getSipConfigsObject();
        Object params[] = {attrList, entityList, handlerProps, configName};
        String types[] = {attrList.getClass().getName(), entityList.getClass().getName(), 
            handlerProps.getClass().getName(), configName.getClass().getName()};
        JMXUtil.invoke(sipConfigsObject, "createIdentityAssertionTrust", params, types);
    }

    public static void deleteTrustConfig(String configName, String id) throws Exception{
        Object params[] = {id, configName};
        String types[] = SipUtil.getSignatureArray(params);
        ObjectName sipConfigsObject = SipUtil.getSipConfigsObject();
        JMXUtil.invoke(sipConfigsObject, "deleteIdentityAssertionTrust", params, types);
    }
    
    
}
