/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.util;

import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;

/**
 *
 * @author irfan
 */
public class SipTargetUtil {
    
    /** Creates a new instance of SipTargetUtil */
    public SipTargetUtil() {
    }
    
    /** Need to do this to get the status of the deployed app from the TargetUtil as TargetUtil
     *  does not support the extension modules
     */
    public static String getEnabledStatus(ObjectName sipApp) {
        String appName = (String) JMXUtil.getAttribute(sipApp, "name");
        
        if (AMXUtil.isEE()) {
            List<String> targetList = TargetUtil.getDeployedTargets(appName,
                    true);
            
            if (targetList.size() == 0) {
                return TargetUtil.convertStatusSummary(TargetUtil.APP_NO_TARGET);
            }
            
            int total = 0;
            
            for (String target : targetList) {
                if (isApplicationEnabled(sipApp, target, false)) {
                    total++;
                }
            }
            
            if (total == targetList.size()) {
                return TargetUtil.convertStatusSummary(TargetUtil.APP_ALL_ENABLED);
            }
            
            if (total == 0) {
                return TargetUtil.convertStatusSummary(TargetUtil.APP_ALL_DISABLED);
            }
            
            return TargetUtil.convertStatusSummary(total);
        }
        
        boolean status = isApplicationEnabled(sipApp, "server", false);
        
        return Boolean.toString(status);
    }
    
    public static boolean isApplicationEnabled(ObjectName sipApp,
            String target, Boolean forLB) {
        boolean master = Boolean.parseBoolean((String) JMXUtil.getAttribute(
                sipApp, "enabled"));
        
        if (!master) {
            return false; // no need to look at ref if master is off.
        }
        
        String name = (String) JMXUtil.getAttribute(sipApp, "name");
        DeployedItemRefConfig ref = TargetUtil.getDeployedItemRefObject(name,
                target);
        
        if (forLB) {
            if (ref != null) {
                return ref.getLBEnabled();
            } else {
                return false;
            }
        }
        
        if (ref == null) {
            return master;
        }
        
        return ref.getEnabled();
    }
    
    public static void setApplicationEnabled(ObjectName sipApp, String target,
            boolean enabledFlag, boolean forLB) {
        //We use the ref to control enable status
        String name = (String) JMXUtil.getAttribute(sipApp, "name");
        DeployedItemRefConfig ref = TargetUtil.getDeployedItemRefObject(name,
                target);
        
        if (forLB) {
            if (ref != null) {
                ref.setLBEnabled(enabledFlag);
            }
            
            return;
        }
        
        if (enabledFlag) {
            JMXUtil.setAttribute(sipApp, new Attribute("enabled", true));
        }
        
        if (ref != null) {
            ref.setEnabled((Boolean) enabledFlag);
        }
    }
    
    public static ArrayList getAllTargets() {
        Set<String> clusteredSet = AMXUtil.getDomainConfig().getClusterConfigMap().keySet();
        Set standaloneSet = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().keySet();
        ArrayList<String> serverList = new ArrayList(standaloneSet);
        serverList.addAll(clusteredSet);
        return serverList;
    }
}
