/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import javax.servlet.sip.SipServletRequest;


/**
 * A request used in the consistent hash based routers.
 */
public class ConsistentHashRequest {
    private SipServletRequest sipRequest;
    private HttpRequest httpRequest;
    private String hashKey;
    private boolean isHttp;

    /**
     * Creates an instance.
     * @param request the sip request
     * @param hashKey an already extracted hash key
     *
     */
    public ConsistentHashRequest(SipServletRequest request, String hashKey) {
        this.sipRequest = request;
        this.hashKey = hashKey;
        this.isHttp = false;
    }

    /**
    * Creates an instance.
    * @param request the http request
    * @param hashKey an already extracted hash key
    */
    public ConsistentHashRequest(HttpRequest request, String hashKey) {
        this.httpRequest = request;
        this.hashKey = hashKey;
        this.isHttp = true;
    }

    /**
     * Gets the request as HTTP.
     * @return the the request as HTTP
     */
    public HttpRequest getHttpRequest() {
        return httpRequest;
    }

    /**
     * Gets the request as SIP.
     * @return the the request as SIP
     */
    public SipServletRequest getSipRequest() {
        return sipRequest;
    }

    /**
     * Gets the hash key
     * @return the hashKey
     */
    public String getHashKey() {
        return hashKey;
    }

    /**
     * Sets the hash key.
     * @param hashKey the hash key
     */
    public void setHashKey(String hashKey) {
        this.hashKey = hashKey;
    }

    /**
     * Check if the request is an HTTP or SIP request
     * @return true = HTTP; false = SIP
     */
    public boolean isHttp() {
        return isHttp;
    }
}
