/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;


/**
 * This is interface which maintains the complete/active list of instances available for load-balancing.
 * The load-balancing policy and clusters part are integral part of a
 * router. The router is initimated of cluster membership changes. It maintains a complete list of
 * instances. This include healthy, unhealthy, enabled and disabled instances. It also maintains a active
 * list of instances which include only healthy and enabled instances. All the requests are router to
 * instances part of the active list.
 *
 * @author kshitiz
 */
public interface Router {
    /**
     * Initializes the router.
     *
     * @return true if initialization is successful
     */
    public boolean initialize();

    /**
     * Select an instance based on request.
     *
     * @param req the request object
     *
     * @return returns the instance to which this request should be forwarded
     */
    public ServerInstance selectInstance(HttpRequest req);

    /**
     * Select an instance based on request.
     *
     * @param req the request object
     *
     * @return returns the instance to which this request should be forwarded
     */
    public ServerInstance selectInstance(ConsistentHashRequest req);

    /**
     * this method handles the event of instance being disabled
     *
     * @param instance instance being disabled
     */
    public void handleDisableEvent(ServerInstance instance);

    /**
     * this method handles the event of instance being enabled
     *
     * @param instance instance being enabled
     */
    public void handleEnableEvent(ServerInstance instance);

    /**
     * this method handles the event of instance becoming healthy
     *
     * @param instance instance becoming healthy
     */
    public void handleRecoveryEvent(ServerInstance instance);

    /**
     * this method handles the event of instance becoming unhealthy
     *
     * @param instance instance becoming unhealthy
     */
    public void handleFailureEvent(ServerInstance instance);

    /**
     * Sets the controller on router
     * @param controller associated controller
     */
    public void setController(Controller controller);
}
