/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipServletRequest;
import org.jvnet.glassfish.comms.util.LogUtil;


/**
 * Extracts a hash key by querying the contained extractors, in the reverse
 * order they where added, i.e. starting with the last one added. The first that
 * returns a non-null value is used. If none produces a hash key, null is
 * returned.
 */
public class CompositeHashKeyExtractor implements HashKeyExtractor,
    Iterable<HashKeyExtractor> {
    private List<HashKeyExtractor> extractors = new ArrayList<HashKeyExtractor>();
    private Logger _logger = LogUtil.CLB_LOGGER.getLogger();

    public void push(HashKeyExtractor hke) {
        extractors.add(0, hke);
    }

    public String getHashKey(HttpRequest request) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE,
                "clb.number_of_hask_key_extractors",
                new Object[]{extractors.size()});
        }
        for (HashKeyExtractor extractor : extractors) {
            String hk = extractor.getHashKey(request);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE,
                    "clb.value_of_key_extracted_by_extractor",
                    new Object[]{extractor, hk});
            }
            if (hk != null) {
                return hk;
            }
        }

        return null;
    }

    public String getHashKey(SipServletRequest request) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE,
                "clb.number_of_hask_key_extractors",
                new Object[]{extractors.size()});
        }
        for (HashKeyExtractor extractor : extractors) {
            String hk = extractor.getHashKey(request);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE,
                    "clb.value_of_key_extracted_by_extractor",
                    new Object[]{extractor, hk});
            }
            if (hk != null) {
                return hk;
            }
        }

        return null;
    }

    public Iterator<HashKeyExtractor> iterator() {
        // Avoid concurrent modification when iterating...
        return ((ArrayList<HashKeyExtractor>) ((ArrayList<HashKeyExtractor>) extractors).clone()).iterator();
    }
}
