/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;

import javax.servlet.sip.SipServletRequest;


/**
 * This interface specifies the component that provides the
 * capability to extract a hash key from a SIP or HTTP request. The extracted hash key is
 * to be used when doing lookup in the
 * {@link org.jvnet.glassfish.comms.clb.core.util.ConsistentHash}
 */
public interface HashKeyExtractor {
    /**
     * Get the hash key to be used in lookup of back-end via the consistent hash
     * function.
     *
     * @param req the request
     * @return the hash key
     */
    public String getHashKey(HttpRequest request);

    /**
     * Get the hash key to be used in lookup of back-end via the consistent hash
     * function.
     *
     * @param req the request
     * @return the hash key
     */
    public String getHashKey(SipServletRequest req);
}
