/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;


/**
 * An "and" condition is true if and only if all its constituent conditions are
 * true. This operator is evaluated for each element in the condition list.
 */
public class AndOperator extends Operator {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * Evaluate the condition
     *
     * @param object The object to evaluate
     * @return True if the operand or operator evaluation is satisfied, false
     *         otherwise
     */
    @Override
    public String evaluate(Object object) {
        String result = null;

        // Loop through all sub Conditions, if anyone returns false, i.e.
        // null and returns null, otherwise <and> returns the the return
        // value of the last child condition
        for (int i = 0; i < subConditions.size(); i++) {
            result = subConditions.get(i).evaluate(object);

            if (result == null) {
                // A subcondition was false, so <and> fails
                return null;
            }
        }

        return result;
    }
}
