/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import javax.servlet.sip.SipServletRequest;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.w3c.dom.Element;


public class HeaderCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private String headerName = null;

    public HeaderCondition() {
    }

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public void addElmentData(Element element) {
        headerName = element.getAttribute("name");

        String returnCondition = element.getAttribute("return");

        if (returnCondition != null) {
            setReturnCondition(returnCondition);
        }
    }

    @Override
    public String evaluate(Object request) {
        int conditionType = getConditionType();

        String headerVal = null;

        if (request instanceof SipServletRequest) {
            headerVal = ((SipServletRequest) request).getHeader(headerName);
        } else if (request instanceof HttpRequest) {
            headerVal = ((HttpRequest) request).getHeader(headerName);
        }

        if (headerName == null) {
            return null;
        }

        switch (conditionType) {
        case TYPE_EQUALS:

            try {
                String mappingHeader = getValue();

                if (mappingHeader.equals(headerVal)) {
                    return processReturnLogic(request, getReturnCondition());
                }
            } catch (Exception e) {
                return null;
            }

        case TYPE_DEFINED: // exist

            if (headerVal != null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_UNDEFINED: // notexist

            if (headerVal == null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_CONTAINS:
            return null;

        case TYPE_EXCLUDE:
            return null;
        }

        return null;
    }
}
