/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import org.w3c.dom.Element;


public class IfOperator extends Operator {
    private static final long serialVersionUID = -4232218361369383390L;
    protected String elseBranchCondition = null;

    public IfOperator() {
    }

    @Override
    public void addChild(Element element) {
        if ("else".equals(element.getNodeName())) {
            elseBranchCondition = element.getAttribute("return");
        } else {
            super.addChild(element);
        }
    }

    @Override
    public String evaluate(Object object) {
        // First check the subconditions
        for (int i = 0; i < subConditions.size(); i++) {
            // TODO if accepts only one sub condition
            String result = subConditions.get(i).evaluate(object);

            if (result != null) {
                return result;
            }
        }

        if (elseBranchCondition != null) {
            return processReturnLogic(object, elseBranchCondition);
        }

        return null;
    }
}
