/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.w3c.dom.Element;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.sip.SipServletRequest;


public class RequestUriCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private String parameterName = null;

    public RequestUriCondition() {
    }

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public void addElmentData(Element element) {
        parameterName = element.getAttribute("parameter");

        String returnCondition = element.getAttribute("return");

        if (returnCondition != null) {
            setReturnCondition(returnCondition);
        }
    }

    @Override
    public String evaluate(Object request) {
        int conditionType = getConditionType();

        String parameterVal = null;

        if (request instanceof SipServletRequest) {
            parameterVal = ((SipServletRequest) request).getParameter(parameterName);
        } else if (request instanceof HttpRequest) {
            parameterVal = ((HttpRequest) request).getParameters().getParameter(parameterName);
        }

        if (parameterName == null) {
            return null;
        }

        switch (conditionType) {
        case TYPE_DEFINED:

            if (parameterVal != null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_UNDEFINED:

            if (parameterVal == null) {
                return processReturnLogic(request, getReturnCondition());
            } else {
                return null;
            }

        case TYPE_MATCH:

            try {
                Pattern reqUriPattern = getMatchExpression();

                if (reqUriPattern == null) {
                    return null;
                }

                String requestUri = null;

                if (request instanceof SipServletRequest) {
                    // URI requestUri = ((SipServletRequest) request
                    // ).getRequestURI(); // TODO should never happen
                    /*
                     * This fix shoule provide match and match.resolve.user for
                     * SIP as well. New JUnit and add to QS and SAD. Old test
                     * still work so add new code next time.
                     */
                    requestUri = ((SipServletRequest) request).toString();
                } else if (request instanceof HttpRequest) {
                    requestUri = ((HttpRequest) request).requestURI().toString();
                }

                Matcher m = reqUriPattern.matcher(requestUri);

                if (!m.find()) {
                    return null; // no match
                }

                if (m.groupCount() >= 1) {
                    if (returnCondition.equals("match")) {
                        return m.group(1);
                    }

                    if (returnCondition.equals("match.resolve.user")) {
                        return DcrUtils.getInstance().getUserPart(m.group(1));
                    }
                } else {
                    return "In order to get a return value a group has to be specified in the pattern"; // did
                                                                                                        // match but nor return value
                }
            } catch (Exception e) {
                return null;
            }
        }

        return null;
    }
}
