/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.core.common.chr.dcr;

import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.dns.ResolverManager;

import org.jvnet.glassfish.comms.util.LogUtil;

import org.w3c.dom.Element;

import java.util.logging.Level;


public class SessionCaseCondition extends Operand {
    private static final long serialVersionUID = 1L;
    private static LogUtil logger = new LogUtil(LogUtil.CLB_LOG_DOMAIN);

    @Override
    public void addChild(Element element) {
        super.addChild(element);
    }

    @Override
    public String evaluate(Object object) {
        int conditionType = getConditionType();

        switch (conditionType) {
        case TYPE_EQUALS:

            try {
                SipServletRequestImpl sipreq = (SipServletRequestImpl) object;
                ResolverManager.getInstance().checkRouteHeader(sipreq, false);

                String actualSessionCase = sipreq.getSessionCase().toString();

                if (logger.isLoggable(Level.FINE)) {
                    logger.logMsg(Level.FINE,
                        "SessionCase: " + actualSessionCase);
                }

                String mappingSessionCase = getValue();

                // session-case has to have sub conditions to return true
                if (actualSessionCase.equals(mappingSessionCase)) {
                    return getSubCondition().evaluate(object);
                }
            } catch (Exception e) {
                logger.logMsg(Level.FINE, "" + e);

                return null;
            }

            break;

        case TYPE_CONTAINS:
            return null;

        case TYPE_EXCLUDE:
            return null;
        }

        return null;
    }
}
