/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy;


import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.layers.LoadBalancerLayer;
import org.jvnet.glassfish.comms.clb.proxy.http.layers.ParserLayer;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;
import org.jvnet.glassfish.comms.httplayers.HttpLayerHandler;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author
 */
public class ProxyLayerHandler {
    private Logger _logger;
    
    /**
     * Creates a new instance of ProxyLayerHandler
     */
    public ProxyLayerHandler() {
        _logger = ProxyConfig.getInstance().getLogger();
        addBasicLayer(new ParserLayer());
        if (ProxyConfig.getInstance().isTestMode()){
            addLayer(new LoadBalancerLayer());
        }
    }
    
    public void doInvoke(Request request, Response response) {
        List<HttpLayer> layers = HttpLayerHandler.getInstance().getHttpLayers();
        
        if (layers.size() > 0) {
            boolean status = true;
            int i;
            
            for (i = 0; i < layers.size(); i++) {
                try {
                    HttpLayer layer = (HttpLayer) layers.get(i);
                    
                    if (_logger.isLoggable(Level.FINE)){
                        _logger.log(Level.FINE,
                                "clb.proxy.before_invoking_layer", layer.getClass().getName());
                    }
                    status = layer.invoke(request, response);
                    if (_logger.isLoggable(Level.FINE)){
                        _logger.log(Level.FINE,
                                "clb.proxy.after_invoking_layer", layer.getClass().getName());
                    }
                } catch (Exception ex) {
                    ex.printStackTrace();
                    response.setStatus(500);
                    status = false;
                }
                
                if (!status) {
                    break;
                }
            }
        } else {
            _logger.log(Level.SEVERE, "clb.proxy.no_layers");
        }
    }
    
    public void addLayer(HttpLayer nextlayer) {
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.adding_layer" +
                    nextlayer.getClass().getName());
        }
        HttpLayerHandler.getInstance().addLayer(nextlayer);
    }
    
    public void addLayers(List<HttpLayer> layers) {
        for (HttpLayer layer : layers) {
            if (_logger.isLoggable(Level.FINE)){
                _logger.log(Level.FINE, "clb.proxy.adding_layer" +
                        layer.getClass().getName());
            }
            HttpLayerHandler.getInstance().addLayer(layer);
        }
    }
    
    public void addBasicLayer(HttpLayer layer) {
        HttpLayerHandler.getInstance().addBasicLayer(layer);
    }
    
    public int layerCount() {
        return HttpLayerHandler.getInstance().getHttpLayers().size();
    }
}
