/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.config;

import com.sun.grizzly.util.buf.ByteChunk;


/**
 *
 * @author rampsarathy
 */
public final class LoadBalancerProxyConstants {
    /**
     * Content length header
     */
    public static final String CONTENT_LENGTH = "content-length";
    
    /**
     * Converged proxy header
     */
    public static final String HTTP_PROXY_HEADER = "felb";
    
    /**
     * Default read timeout for socket read
     */
    public static final int DEFAULT_READ_TIMEOUT = 1500;
    
    /**
     * Default HTTP header buffer size.
     */
    public static final int DEFAULT_HTTP_HEADER_BUFFER_SIZE = 8 * 1024;
    
    /**
     * CRLF.
     */
    public static final String CRLF = "\r\n";
    
    /**
     * Connection header.
     */
    public static final String HTTP_CONNECTION_HEADER = "connection";
    /**
     * Connection close value.
     */
    public static final String HTTP_CONNECTION_CLOSE_VALUE = "close";
    /**
     * domain.xml attributes.
     */
    /**
     * Clb module name
     */
    private static final String PACKAGE_NAME = "clb";
    /**
     * Default log level
     */
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    /**
     * Http request Pool size.
     */
    public static final int HTTP_PAYLOAD_POOL_SIZE = 100;
    /**
     * Https request pool size.
     */
    public static final int HTTPS_PAYLOAD_POOL_SIZE = 100;
    /**
     * SSL input buffer size.
     */
    public static final int DEFAULT_INPUTBB_SIZE = 5 * 4096;
    /**
     * Maximum retries for send to remote instance.
     */
    public static final int MAX_SEND_RETRY = 3;
    
    public static final String HTTP_11 = "HTTP/1.1 ";
    
    public static final byte[] HTTP_11_BYTES =
            ByteChunk.convertToBytes(HTTP_11);
    
    public static final int SSL_HEADER_SIZE = 1024;
    
    protected static final String END = "0\r\n\r\n";
    
    public static final byte[] END_BYTES =
            ByteChunk.convertToBytes(END);
    public static final int DEFAULT_CERT_CHAIN_SIZE = 8*1024;
    
    public static final String CERT_HEADER = "Proxy-auth-cert : ";
    
    public static final byte [] CERT_HEADER_BYTES =
            ByteChunk.convertToBytes(CERT_HEADER);
    
    public final static byte[] TE_HEADER = "transfer-encoding".getBytes();   
    
}
