/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.clb.proxy.http.layers;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpInputBuffer;
import org.jvnet.glassfish.comms.clb.proxy.http.util.HttpRequest;
import org.jvnet.glassfish.comms.httplayers.HttpLayer;

import java.io.IOException;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author
 */
public class ParserLayer implements HttpLayer {
    Logger _logger = null;
    
    /** Creates a new instance of ParserLayer */
    public ParserLayer() {
        _logger = ProxyConfig.getInstance().getLogger();
    }
    
    @SuppressWarnings("empty-statement")
    public boolean invoke(Request request, Response response)
    throws Exception {
        HttpInputBuffer buffer = (HttpInputBuffer) request.getInputBuffer();
        HttpRequest httpReq = (HttpRequest) request;
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.parserlayer_begin");
        }
        try {
            buffer.parseRequestLine();
            
            if (_logger.isLoggable(Level.FINE)) {
                // dumpBuffer(buffer);
                httpReq.dump();
            }
            
            buffer.parseHeaders();
            
            if (_logger.isLoggable(Level.FINE)) {
                httpReq.dumpHeaders();
            }
        } catch (IOException e) {
            e.printStackTrace();
            throw e;
            
            // ignore
        } finally {
            ;
        }
        if (_logger.isLoggable(Level.FINE)){
            _logger.log(Level.FINE, "clb.proxy.test.parserlayer_end");
        }
        return true;
    }
    
    private void dumpBuffer(HttpInputBuffer parser) {
        StringBuffer sbuf = new StringBuffer();
        
        for (int i = 0; i < parser.lastValidPos(); i++) {
            sbuf.append((char) parser.getBytes()[i]);
        }
        
        _logger.log(Level.FINE, sbuf.toString());
    }
}
