/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package org.jvnet.glassfish.comms.clb.proxy.http.util;

import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueue;
import com.sun.grizzly.connectioncache.spi.concurrent.ConcurrentQueueFactory;

import org.jvnet.glassfish.comms.clb.proxy.ProxyRequestHandler;
import org.jvnet.glassfish.comms.clb.proxy.config.LoadBalancerProxyConstants;
import org.jvnet.glassfish.comms.clb.proxy.config.ProxyConfig;


/**
 * This is an object manager implementation using the ConcurrentQueue from
 * grizzly.
 *
 * @author rampsarathy
 */
public class ObjectManager {
    private static ObjectManager _thisInstance = null;
    private ConcurrentQueue<ProxyRequestHandler> tasks;
    private ConcurrentQueue<ProxyRequestHandler> ssltasks;

    /** Creates a new instance of ObjectManager */
    private ObjectManager() {
    }

    public static synchronized ObjectManager getInstance() {
        if (_thisInstance == null) {
            _thisInstance = new ObjectManager();
        }

        return _thisInstance;
    }

    public void initialize() {
        tasks = ConcurrentQueueFactory.makeConcurrentQueue();

        for (int i = 0; i < ProxyConfig.getInstance().getRequestPoolSize(); i++) {
            tasks.offer(new ProxyRequestHandler(false));
        }

        ssltasks = ConcurrentQueueFactory.makeConcurrentQueue();

        for (int i = 0; i < ProxyConfig.getInstance().getRequestPoolSize(); i++) {
            ssltasks.offer(new ProxyRequestHandler(true));
        }
    }

    public ProxyRequestHandler pollTask(boolean secure) {
        if (secure) {
            return ssltasks.poll();
        } else {
            return tasks.poll();
        }
    }

    public void offerTask(ProxyRequestHandler task, boolean secure) {
        if (secure) {
            ssltasks.offer(task);
        } else {
            tasks.offer(task);
        }
    }
}
