/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SunSipApp.java
 *
 * Created on Oct 10, 2007, 1:51:03 PM
 *
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.deployment.runtime.sip;

import com.sun.enterprise.deployment.runtime.web.JspConfig;
import com.sun.enterprise.deployment.runtime.web.Servlet;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;


/**
 * Represents the sun-sip.xml descriptor
 * @author Prasad Subramanian
 */
public class SunSipApp extends SunWebApp {
    static public final String SECURITY_ROLE_MAPPING = "SecurityRoleMapping"; // NOI18N
    static public final String SESSION_CONFIG = "SessionConfig"; // NOI18N
    static public final String RESOURCE_ENV_REF = "ResourceEnvRef"; // NOI18N
    static public final String RESOURCE_REF = "ResourceRef"; // NOI18N
    static public final String EJB_REF = "EjbRef"; // NOI18N
    static public final String CACHE = "Cache"; // NOI18N
    static public final String CLASS_LOADER = "ClassLoader"; // NOI18N
    static public final String LOCALE_CHARSET_INFO = "LocaleCharsetInfo"; // NOI18N
    static public final String PARAMETER_ENCODING = "ParameterEncoding";
    static public final String FORM_HINT_FIELD = "FormHintField";
    static public final String DEFAULT_CHARSET = "DefaultCharset";
    public static final String IDEMPOTENT_URL_PATTERN = "IdempotentUrlPattern";
    public static final String ERROR_URL = "ErrorUrl";

    public SunSipApp() {
        // set default values
        setAttributeValue(CACHE, "MaxEntries", "4096");
        setAttributeValue(CACHE, "TimeoutInSeconds", "30");
        setAttributeValue(CACHE, "Enabled", "false");
    }

    // This attribute is an array, possibly empty
    public void setServlet(int index, Servlet value) {
        //no-op
    }

    //
    public Servlet getServlet(int index) {
        return null;
    }

    // This attribute is an array, possibly empty
    public void setServlet(Servlet[] value) {
        //no-op
    }

    //
    public Servlet[] getServlet() {
        return null;
    }

    // Return the number of properties
    public int sizeServlet() {
        return 0;
    }

    // Add a new element returning its index in the list
    public int addServlet(Servlet value) {
        return 0;
    }

    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeServlet(Servlet value) {
        return 0;
    }

    // This attribute is optional
    public void setJspConfig(JspConfig value) {
        //no-op
    }

    //
    public JspConfig getJspConfig() {
        return null;
    }

    /**
     * Sets the session configuration information from sun-sip.xml.
     *
     * @param value The session configuration information from sun-sip.xml
     */
    public void setSessionConfig(SessionConfig value) {
	setValue(SunWebApp.SESSION_CONFIG, value);
    }
    
    /**
     * Gets the session configuration information from sun-sip.xml.
     *
     * @return The session configuration information from sun-sip.xml
     */
    public SessionConfig getSessionConfig() {
	return (SessionConfig) getValue(SunWebApp.SESSION_CONFIG);
    }

}
