package org.jvnet.glassfish.comms.httplayers;

import com.sun.appserv.server.ServerLifecycleException;

import com.sun.org.apache.commons.digester.Digester;

import org.jvnet.glassfish.comms.util.LogUtil;

import java.io.InputStream;

import java.util.ArrayList;
import java.util.List;


public class HttpLayerHandler {
    private static HttpLayerHandler instance = new HttpLayerHandler();
    private static final LogUtil logger = LogUtil.SIP_LOGGER;
    private List<HttpLayer> httpLayers = new ArrayList<HttpLayer>();

    private HttpLayerHandler() {
    }

    public static HttpLayerHandler getInstance() {
        return instance;
    }

    public void parse(InputStream is) throws ServerLifecycleException {
        try {
            Digester digester = new Digester();
            digester.setClassLoader(HttpLayerHandler.class.getClassLoader());
            digester.setValidating(false);
            digester.addRule("*/dispatcher", new HttpLayerRule(httpLayers));
            digester.parse(is);
            logger.info("HttpLayers read from input stream: " + httpLayers);
        } catch (Exception e) {
            throw new ServerLifecycleException("Failure when parsing dispatcher.xml",
                e);
        }
    }

    /**
     * Gets a copy of the collection of HTTP layers
     *
     * @return a copy the collection of HTTP layers
     */
    public List<HttpLayer> getHttpLayers() {
        return new ArrayList<HttpLayer>(httpLayers);
    }

    /**
     * Adds a layer.
     *
     * @param layer
     */
    public void addLayer(HttpLayer layer) {
        httpLayers.add(layer);
    }

    /**
     * Adds a basic layer.
     *
     * @param layer
     */
    public void addBasicLayer(HttpLayer layer) {
        httpLayers.add(0, layer);
    }
}
