/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package org.jvnet.glassfish.comms.httplayers;

import com.sun.org.apache.commons.digester.Rule;

import org.jvnet.glassfish.comms.util.LogUtil;

import org.xml.sax.Attributes;

import java.lang.reflect.Method;

import java.util.Collection;
import java.util.logging.Level;


public class HttpLayerRule extends Rule {
    private static final String GET_LAYER_INSTANCE_METHOD = "getHttpLayerInstance";
    private static final String HTTP_LAYER_ATTR = "httpLayer";
    private static final String CLASS_NAME_ATTR = "className";
    private static final String HTTP_PROXY_CLASS_NAME = "org.jvnet.glassfish.comms.clb.proxy.HttpProxy";
    private static final LogUtil logger = LogUtil.SIP_LOGGER;
    private Collection<HttpLayer> layers;
    private Object httpProxyObject;
    private Method addLayerMethod;

    /**
     * Creates the rule.
     *
     * @param layers the collection into which parsed layers are put
     */
    public HttpLayerRule(Collection<HttpLayer> layers) {
        this.layers = layers;
    }

    public void begin(String ns, String n, Attributes attributes)
        throws Exception {
        // The className attribute has to be defined in xml,
        // otherwise we cannot retreive the HttpLayer instance
        String className = attributes.getValue(CLASS_NAME_ATTR);

        if (className == null) {
            throw new Exception("Attribute " + CLASS_NAME_ATTR + " is missing");
        }

        // Find the singelton instance for the className class.
        try {
            boolean isBasic = "true".equalsIgnoreCase(attributes.getValue(
                        HTTP_LAYER_ATTR));

            if (isBasic) {
                Class<?> layerClass = Class.forName(className);
                Method method = layerClass.getMethod(GET_LAYER_INSTANCE_METHOD,
                        (Class[]) null);
                Object object = method.invoke((Object) null, (Object[]) null);

                // The getBasicLayerInstance() method may return null if the
                // layer is configured to exclude itself via domain.xml
                if (object != null) {
                    if (object instanceof HttpLayer) {
                        logger.info("Adding HttpLayer: '" + object + "'");

                        //Commented out adding layer to HttpLayerHandler
                        //layers.add((HttpLayer) object);
                        //Layers are directly added to HttpProxy
                        //Initialize HttpProxy and method if not already done
                        if (addLayerMethod == null) {
                            initializeHttpProxy((HttpLayer) object);
                        }

                        //Add layer to HttpProxy   
                        addLayerMethod.invoke(httpProxyObject,
                            (HttpLayer) object);
                        logger.info("Added HttpLayer: '" + object + "'");
                    }
                }
            }
        } catch (Exception e) {
            logger.log(Level.SEVERE,
                "tried to invoke " + className +
                ".getInstance(), caught exception: " + e.getMessage(), e);
            throw new Exception("Exception invoking getInstance for class " +
                className);
        }
    }

    private void initializeHttpProxy(HttpLayer layer) throws Exception {
        logger.info("Initializing httpProxy object and addLayer method");

        Class httpProxyClass = Class.forName(HTTP_PROXY_CLASS_NAME);
        Method getInstanceMethod = httpProxyClass.getMethod("getInstance",
                (Class[]) null);
        httpProxyObject = getInstanceMethod.invoke((Object) null,
                (Object[]) null);
        addLayerMethod = httpProxyClass.getMethod("addLayer", HttpLayer.class);
    }
}
