/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

/*
 * SipFactoryObjectFactory.java
 *
 * Created on February 15, 2007, 3:45 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.jvnet.glassfish.comms.deployment.backend;

import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.config.SipFactoryMap;

import com.sun.logging.*;

import java.util.Hashtable;
import java.util.logging.*;

import javax.naming.*;
import javax.naming.spi.*;

import javax.servlet.sip.SipFactory;


/**
 * An object factory to handle  SipFactory access
 *
 */
public class SipFactoryObjectFactory implements ObjectFactory {
    static final Logger _logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx,
        Hashtable env) throws Exception {
        InitialContext ic = new InitialContext(env);
        Reference ref = (Reference) obj;
        RefAddr refAddr = ref.get("url");
        String refAddrString = (String) refAddr.getContent();

        //Object genericRemoteHomeObj = ic.lookup((String) refAddr.getContent());
        String busInterface = ref.getClassName();
        _logger.log(Level.INFO,
            "refAddrString = " + refAddrString + " busInterface  = " +
            busInterface);

        SipFactory sf = (SipFactoryMap.getInstance()).getSipFactory(refAddrString);

        return sf;
    }
}
