/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

package org.jvnet.glassfish.comms.admin.callflow.reporter;

import com.ericsson.ssa.container.callflow.Reporter;
import com.ericsson.ssa.sip.Layer;
import org.jvnet.glassfish.comms.admin.callflow.*;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestInfo;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.jvnet.glassfish.comms.util.LogUtil;


public class CallflowReporter implements Reporter{
    
    final static  Agent agent = Switch.getSwitch().getCallFlowAgent();
    final static LogUtil log = LogUtil.SIP_LOGGER;

    public void report(Layer l, SipServletRequest r) {
        if( agent.isEnabled()){
            agent.requestStart(SipRequestType.REMOTE_SIP);
            agent.addRequestInfo(RequestInfo.CALLER_IP_ADDRESS, r.getRemoteAddr());
            agent.addRequestInfo(RequestInfo.REMOTE_USER, r.getRemoteUser());                       
            agent.startTime(SipContainerOrApplicationType.SIP_APPLICATION);   
        }
    }

    public void report(Layer l, SipServletResponse r) {
        if( agent.isEnabled()){
            agent.endTime();
            agent.requestEnd();
        }
    }

}
