/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/
package org.jvnet.glassfish.comms.admin.config;

import com.ericsson.ssa.config.Config;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.config.ConfigBean;

import org.netbeans.modules.schema2beans.BaseBean;


public interface ConfigBean2InternalMapper {
    //EventListener registration
    boolean requiresEventListerenerRegistration();

    String getEventType();

    AdminEventListener getEventListenerImpl(ConfigAdapter configMapper);

    Class getEventListenerClass();

    //Mapping
    /**
     * Maps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after mapping.
     */
    BaseBean[] map2Internal(ConfigBean bean, String[] ctxHolder, Config config);

    /**
     * Remaps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after remapping.
     */
    BaseBean[] remap2Internal(ConfigBean bean, String[] ctxHolder, Config config);

    /**
     * Unmaps the ConfigBean to the internal structure.
     * @param bean the bean to be mapped.
     * @param ctxHolder the the path to the root element pass within a holder
     * array to allow the implementer to suggest a new ctx to be used when
     * traversing the suggested childeren.
     * @param config the internal Config.
     * @return the the childeren of the bean still to be traverse after unmapping.
     */
    BaseBean[] unmap2Internal(ConfigBean bean, String[] ctxHolder, Config config);
}
