/*
 * SipListenerMapper.java
 *
 * Created on September 2, 2007, 9:55 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.jvnet.glassfish.comms.admin.config;


import com.sun.enterprise.admin.event.ElementChangeEvent;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigDelete;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.ConfigException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.logging.Level;
import org.jvnet.glassfish.comms.util.LogUtil;

/**
 *
 * @author elnelbo
 */
public class ConfigBean2InternalMapperImpl extends BaseMapper implements InvocationHandler {
    private LogUtil log = LogUtil.SIP_LOGGER;
    private ConfigAdapter configAdapter;
    private String eventType;
    private Class eventListenerClass;    
    

    public ConfigBean2InternalMapperImpl(String anEventType, Class anEventListenerClass, boolean isMultiple) {
        super(isMultiple);
        eventType = anEventType;
        eventListenerClass = anEventListenerClass;
    }

    @Override
    public boolean requiresEventListerenerRegistration() {
        return true;
    }

    @Override
    public String getEventType() {
        return eventType;
    }

    @Override
    public AdminEventListener getEventListenerImpl(ConfigAdapter aConfigAdapter) {
        configAdapter = aConfigAdapter;
        return (AdminEventListener) Proxy.newProxyInstance(eventListenerClass.getClassLoader(), new Class[]{eventListenerClass}, this);
    }

    @Override
    public Class getEventListenerClass() {        
        return eventListenerClass;
    }        

    public void handleCreate(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            if (configChange instanceof ConfigAdd) {
                String xpath = ((ConfigAdd)configChange).getXPath();
                try {
                    ConfigBean bean = adminEvent.getConfigContext().exactLookup(xpath);
                    configAdapter.configureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {                    
                    throw new AdminEventListenerException("Failed to lookup bean.", ex);
                }
            }
        }        
    }

    public void handleUpdate(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            String xpath = null;
            
            if (configChange instanceof ConfigAdd) {
                xpath = ((ConfigAdd)configChange).getXPath();
            } else if (configChange instanceof ConfigUpdate) {
                xpath = ((ConfigUpdate)configChange).getXPath(); 
            }
            
            if (xpath!=null) {
                try {
                    ConfigBean bean = adminEvent.getConfigContext().exactLookup(xpath);
                    configAdapter.reconfigureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {
                    throw new AdminEventListenerException("Failed to lookup bean.", ex);
                }
            }
        }        
    }

    public void handleDelete(ElementChangeEvent adminEvent) throws AdminEventListenerException {
        for (Object configChange : adminEvent.getConfigChangeList()) {
            if (configChange instanceof ConfigDelete) {
                String xpath = ((ConfigDelete)configChange).getXPath();
                try {
                    ConfigBean bean = adminEvent.getConfigContext().exactLookup(xpath);
                    configAdapter.unconfigureSpecificContext(bean, xpath2Context(xpath));       
                } catch (ConfigException ex) {
                    throw new AdminEventListenerException("Failed to lookup bean.", ex);
                }
            }
        }        
    }
    
    private String xpath2Context(String xpath) {
        //Note the xpath format is information we actually should not know.
        //Needs to be abstracted properly at some point.
        // /domain/configs/config[@name='server-config']/sip-service/sip-listener[@id='EltjoWasHere']/ssl
        String[] xpathElements = xpath.split("[\\[\\]]+");
        StringBuffer context = new StringBuffer();
        String[] ctxParts = xpathElements[2].split("/");
        
        int i = 0;
        for (String ctxPart : ctxParts) {
            if (ctxPart.length()>0) {
                //A context does not include the element it self        
                if (i<(ctxParts.length-1)) {
                    context.append(ConfigBean.camelize(ctxPart));
                    context.append("/");
                }
            }
            i++;
        }
        
        //Workaround for the only case where a multiple is preceeded by an child element
        //TODO make generic for multiples
        if (xpath.endsWith("/ssl")) {
            context.append("SipListener/");
            context.append(idFromXpath(xpath));
            context.append("/");
        }        
        
        if (log.isLoggable(Level.FINEST)) {
            log.logMsg(Level.FINEST, "xpath2Context: "+xpath+" -> "+context.toString());
        }
        return context.toString();
    }   
    
    private String idFromXpath(String xpath) {
        int start = xpath.indexOf("@id='") + "@id='".length();
        int end = xpath.indexOf("'", start);
        return xpath.substring(start, end);
    }
    
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            // throws Throwable {
            if (log.isLoggable(Level.FINEST)) {
                log.logMsg(Level.FINEST, "EventListener proxy called for event type: " + eventType + "\nMethod = " + method + "\nArgs = " + Arrays.asList(args));
            }
            Method dispatchMethod = null;
            
            try {
                dispatchMethod = getClass().getMethod(method.getName(), ElementChangeEvent.class);
            } catch (NoSuchMethodException ex) {
                //Not supported event, ignore.
            }
            Object result = null;
            if (dispatchMethod != null) {
                try {
                    result = dispatchMethod.invoke(this, args[0]);
                } catch (IllegalAccessException ex) {
                    //Not supported event, ignore.
                } catch (InvocationTargetException ex) {
                    //Hide the fact of proxying and throw the orig exception.
                    throw ex.getTargetException();
                }
            }

            return result;
    }
}
