/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.config;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;

import java.io.*;

import java.util.*;


/*
 * Possibly temperary in this package.
 */

/**
 * Factory for retrieving a particular config. bean given
 * the ConfigContext object.
 * This is the central place where a server resolves the references.
 * There should be no place in the code that accesses beans using context directly.
 */
public final class SipBeansFactory {
    private SipBeansFactory() {
        // disallow instantiation
    }

    public static ServerContext getServerContext() {
        return ApplicationServer.getServerContext();
    }

    public static ConfigContext getConfigContext() {
        return ApplicationServer.getServerContext().getConfigContext();
    }

    public static SipService getSipServiceBean() throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(getConfigContext());
        SipService sipService = cfg.getSipService();

        return sipService;
    }

    public static SipContainer getSipContainerBean() throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(getConfigContext());
        SipContainer sipContainer = cfg.getSipContainer();

        return sipContainer;
    }

    public static String getSipContainerLogLevel() throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(getConfigContext());
        LogService logService = cfg.getLogService();

        ElementProperty sipContainerLogLevel =
            logService.getModuleLogLevels().getElementPropertyByName("sip-container");
        if (sipContainerLogLevel != null)
            return sipContainerLogLevel.getValue();
        else 
            return null;
    }

    public static Set getSipServices() throws ConfigException {
        final Set result = new HashSet();

        for (final Iterator it = ServerBeansFactory.getConfigs(
                    getConfigContext()).iterator(); it.hasNext();) {
            result.add(((Config) it.next()).getSipService());
        }

        return result;
    }
    
    public static Config getCurrentConfig() throws ConfigException {
        return ServerBeansFactory.
                getConfigBean(getConfigContext());
    }
}
