/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */

package org.jvnet.glassfish.comms.replication.sessmgmt;

import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipStore;
import com.sun.appserv.ha.spi.BackingStore;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.WebIOUtilsFactory;
import org.jvnet.glassfish.comms.util.LogUtil;

public class SipStoreBase implements SipStore {

    protected static final Logger _logger = Logger.getLogger(LogUtil.SIP_LOG_DOMAIN);
    protected static final String MODE_SIP = ReplicationState.MODE_SIP;    

    protected SipSessionManager manager;
    
    /**
     * A utility class used to call into services from IOUtils
     */
    private IOUtilsCaller webUtilsCaller = null;    

    /**
     * Gets the session manager of this store.
     *
     * @return The session manager of this store
     */
    public SipSessionManager getSipSessionManager() {
        return manager;
    }

    /**
     * Sets the session manager for this store.
     *
     * @param manager The session manager for this store.
     */
    public void setSipSessionManager(SipSessionManager manager) {
        this.manager = manager;
    }
    
    protected String getApplicationId() {
        return this.getSipSessionManager().getApplicationId();
    } 
}
