/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import javax.servlet.sip.SipServletMessage;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class AuthHeaderProcessor {
    public String[] getHeaderValues(SipServletMessage message,
        String headerName, String headerValueName) {
        @SuppressWarnings(value = "unchecked")
        ListIterator<String> params = message.getHeaders(headerName);

        if (params == null) {
            return null;
        }

        ArrayList<String> realms = new ArrayList<String>();

        if (params == null) {
            return null;
        }

        while (params.hasNext()) {
            String currentToken = params.next();

            if (currentToken.startsWith("Digest")) {
                currentToken = currentToken.substring("Digest".length());
                currentToken.trim();
            }

            int equalSign = currentToken.indexOf('=');

            if (equalSign < 0) {
                return null;
            }

            String realmName = null;
            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1)
                                                   .trim();

            if (headerValueName.equalsIgnoreCase(currentTokenName)) {
                realmName = removeQuotes(currentTokenValue, true);
                realms.add(realmName);
            }
        }

        return  realms.toArray(new String[0]
                );
    }

    public List<List<Header>> getHeaderValues(SipServletMessage message,
        String headerName) {
        ArrayList<List<Header>> headers = new ArrayList<List<Header>>();
        @SuppressWarnings(value = "unchecked")
        ListIterator<String> params = message.getHeaders(headerName);

        if (params == null) {
            return null;
        }

        ArrayList<Header> list = list = new ArrayList<Header>();

        while (params.hasNext()) {
            String currentToken = params.next();

            //remove Digest
            if (currentToken.startsWith("Digest")) {
                currentToken = currentToken.substring("Digest".length());
                currentToken.trim();
                list = new ArrayList<Header>();
                headers.add(list);
            }

            int equalSign = currentToken.indexOf('=');

            if (equalSign < 0) {
                return null;
            }

            String currentTokenName = currentToken.substring(0, equalSign).trim();
            String currentTokenValue = currentToken.substring(equalSign + 1)
                                                   .trim();
            list.add(new Header(currentTokenName, currentTokenValue));
        }
       

        return headers;
    }

    public static String removeQuotes(String quotedString,
        boolean quotesRequired) {
        //support both quoted and non-quoted
        if ((quotedString.length() > 0) && (quotedString.charAt(0) != '"') &&
                !quotesRequired) {
            return quotedString;
        } else if (quotedString.length() > 2) {
            return quotedString.substring(1, quotedString.length() - 1);
        } else {
            return new String();
        }
    }
}
