/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.auth.impl;

import com.sun.enterprise.security.auth.TrustHandler;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class TrustHandlerImpl implements TrustHandler {

    private Properties props;

    public void initialize(Properties props) {
        this.props = props;
    }

    public boolean isTrusted(String asserterAddress, String messageDirection, X509Certificate securityid, Principal[] pAssertedValues) {
        //TODO: check for certs and by default accept all ip address
        return true;
    }

    public Principal[] mapIdentity(Principal[] principals) {
        ArrayList<Principal> list = new ArrayList<Principal>();
        if (principals != null) {
            for (int i = 0; i < principals.length; i++) {
                Principal p = principals[i];
                String name = p.getName();
                StringTokenizer st = new StringTokenizer(name);
                boolean added = false;
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    int endIndex = token.indexOf("@");
                    int startIndex = token.indexOf(":");
                    if (startIndex > 0 && endIndex > 0) {
                        final String prin;
                        prin = token.substring(startIndex+1, endIndex);
                        added = true;
                        list.add(new Principal() {

                            public String getName() {
                                return prin;
                            }
                        });
                        break;
                    }
                }
                if (!added) {
                    list.add(p);
                }
            }
        }
        return list.toArray(new Principal[0]);
    }
}
