/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.authorize;

import java.security.Permission;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class SipResourcePermission extends Permission {
    //private String [] methods = null;
    private Set<String> methods = null;
    private String mthds = null;
    private boolean exception = false;

    /** Creates a new instance of SipResourcePermission */
    public SipResourcePermission(String name, String methods) {
        super(name);
        this.methods = new HashSet<String>();
        parse(methods);
    }

    public SipResourcePermission(String name, Set<String> methods) {
        super(name);
        this.methods = methods;
    }

    public SipResourcePermission(boolean exception, String name, Set<String> methods) {
        super(name);
        this.methods = methods;
        this.exception = exception;
    }

    public boolean implies(Permission permission) {
        if ((permission == null) &&
                !(permission instanceof SipResourcePermission)) {
            return false;
        }

        if (!(this.getName().equals(permission.getName()))) {
            return false;
        }

        if (this.methods == null || this.methods.size() == 0) {
            return true;
        }

        SipResourcePermission srp = (SipResourcePermission) permission;
        if (exception) {
            Set<String> grantMethod = srp.methods;
            if (grantMethod.isEmpty()) {
                return false;
            }
            Iterator itr = grantMethod.iterator();

            while (itr.hasNext()) {
                String name = (String) itr.next();
                if (this.methods.contains(name)) {
                    return false;
                }
            }
            return true;
        }

        if (srp.methods == null || srp.methods.size() == 0) {
            return false;
        }

        Set<String> grantMethod = srp.methods;

        if (grantMethod.isEmpty()) {
            return false;
        }

        Iterator itr = grantMethod.iterator();

        while (itr.hasNext()) {
            String name = (String) itr.next();

            if (!methods.contains(name)) {
                return false;
            }
        }

        return true;
    }

    public boolean equals(Object object) {
        boolean equal = false;

        if (object instanceof SipResourcePermission) {
            SipResourcePermission srp = (SipResourcePermission) object;

            if ((this.getName() != null) &&
                    this.getName().equals(srp.getName())) {
                if (srp.methods.size() == this.methods.size()) {
                    Iterator<String> itr = srp.methods.iterator();

                    while (itr.hasNext()) {
                        String method = itr.next();

                        if (this.methods.contains(method)) {
                            break;
                        }
                    }

                    equal = true;
                }
            }
        }

        return equal;
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(this.getActions());

        return buffer.toString().hashCode();
    }

    public String getActions() {
        if (mthds == null) {
            StringBuilder sb = new StringBuilder();

            Iterator<String> itr = methods.iterator();
            if (itr.hasNext() && exception) {
                sb.append("!");
            }
            if (itr.hasNext()) {
                String value = itr.next();
                sb.append(value);
            }
            while (itr.hasNext()) {
                sb.append(",");

                String value = itr.next();
                sb.append(value);
            }

            mthds = sb.toString();
        }

        return mthds;
    }

    private void parse(String methods) {
        if (methods != null &&  (methods.length() == 0)){
            return;
        }
        if((methods.charAt(0) == '!')) {
            exception = true;
            methods = methods.substring(1);
        }
        StringTokenizer st = new StringTokenizer(methods, ",");

        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.methods.add(token);
        }
    }
}
