/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.security.authorize;

import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

/**
 *
 * @author K.Venugopal@sun.com
 */
public class SipUserDataPermission extends Permission implements java.io.Serializable {

    private Set<String> methods = null;
    private String transportType = null;
    private String mthds = null;
    private boolean exception = false;

    public SipUserDataPermission(String name, Set<String> methods, String tv) {
        super(name);
        this.methods = methods;
        this.transportType = tv;
        if (transportType == null || transportType.length() == 0) {
            this.transportType = "NONE";
        }
    }

    public SipUserDataPermission(String name, String action) {
        super(name);

        this.methods = new HashSet();
        parse(action);
    }

    public boolean implies(Permission perm) {
        if (!(perm instanceof SipUserDataPermission)) {
            return false;
        }

        SipUserDataPermission udp = (SipUserDataPermission) perm;
        if ("NONE".equals(this.transportType) && this.methods.size() ==0) {
            return true;
        }
        boolean tt = false;
        if("NONE".equals(this.transportType) || udp.transportType.equals(transportType)){
            tt = true;
        }

        Iterator<String> iterator = udp.methods.iterator();
        if (exception) {
            Set<String> grantMethod = udp.methods;
            if (grantMethod.isEmpty()) {
                return false;
            }
            Iterator itr = grantMethod.iterator();

            while (itr.hasNext()) {
                String name = (String) itr.next();
                if (this.methods.contains(name)) {
                    return false;
                }
            }
            return true;
        }

        if(this.methods == null || this.methods.size() ==0){
            return true;
        }
        
        boolean mthdFound = false;
        
        while (iterator.hasNext()) {
            String m = iterator.next();
            if (this.methods.contains(m)) {
                mthdFound = true;
            }
        }
        if((tt && mthdFound ) || !mthdFound){
            return true;
        }
        return false;
    }

    public boolean equals(Object perm) {
        if (!(perm instanceof SipUserDataPermission)) {
            return false;
        }
        SipUserDataPermission sip = (SipUserDataPermission) perm;
        if (!this.transportType.equals(sip.transportType)) {
            return false;
        }
        if (!(this.exception == sip.exception)) {
            return false;
        }

        if (this.methods.size() != sip.methods.size()) {
            return false;
        }

        Iterator<String> itr = sip.methods.iterator();

        while (itr.hasNext()) {
            String value = itr.next();
            if (!this.methods.contains(value)) {
                return false;
            }
        }
        return true;

    }

    public int hashCode() {
        int mhash = 0,thash=0;
        if(methods != null)mhash = methods.hashCode();
        if(transportType != null)thash = transportType.hashCode();
        
        return this.getName().hashCode() + mhash+ thash;
    }

    public String getActions() {
        if (mthds == null) {
            StringBuilder sb = new StringBuilder();
            if (methods == null || methods.size() == 0) {
                mthds = "";
                return "";
            }
            Iterator<String> itr = methods.iterator();
            if (itr.hasNext() && exception) {
                sb.append("!");
            }
            if (itr.hasNext()) {
                String value = itr.next();
                sb.append(value);
            }

            while (itr.hasNext()) {
                sb.append(",");
                String value = itr.next();
                sb.append(value);
            }

            sb.append(":");
            sb.append(transportType);
            mthds = sb.toString();
        }

        return mthds;
    }

    private void parse(String action) {

        if (action != null && (action.length() == 0)) {
            this.transportType = "NONE";
            return;
        }
        if ((action.charAt(0) == '!')) {
            exception = true;
            action = action.substring(1);
        }

        String[] values = action.split(":");
        transportType = values[1];

        String value = values[0];
        StringTokenizer st = new StringTokenizer(value, ",");

        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.methods.add(token);
        }
        if (transportType == null || transportType.length() == 0) {
            this.transportType = "NONE";
        }
    }
}
