/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.sip.container;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.util.Properties;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;


public class PropertiesImporter implements LifecycleListener {
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            // Importing Properties
            File propFile = new File(System.getProperty("catalina.home") +
                    "/conf/system.properties");

            Properties sysProps = new Properties(System.getProperties());

            try {
                sysProps.load(new FileInputStream(propFile));
                System.setProperties(sysProps);
            } catch (Exception e) {
                e.printStackTrace();
            }

            // Importing Properties
            loadPreferenceProperties();
        }
    }

    private void loadPreferenceProperties() {
        String preferenceDirectory = "preferences";
        String catalinaHome = System.getProperty("catalina.home");

        if (catalinaHome != null) {
            preferenceDirectory = catalinaHome + "/conf/preferences";
        }

        try {
            File preferenceDir = new File(preferenceDirectory);

            File[] prefFiles = preferenceDir.listFiles();

            for (int i = 0; i < prefFiles.length; i++) {
                if (prefFiles[i].isDirectory()) {
                    continue;
                }

                String currentFile = prefFiles[i].getName();
                System.out.println("Processing Preferences from " +
                    currentFile);

                FileInputStream fis = new FileInputStream(prefFiles[i]);
                Preferences.importPreferences(fis);
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InvalidPreferencesFormatException e) {
            e.printStackTrace();
        }
    }
}
