/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.annotations;

import java.io.File;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplicationKey;


/**
 * Descriptor for SIP Annotations
 *
 * @author lmcpepe
 *
 */
public class SipAnnotationDescriptor {
    // Annotations
    Method anno_SipApplicationKey = null;
    private ClassLoader loader = null;
    private String classRepository = null;
    private ArrayList<String> repositoryClasses = new ArrayList<String>();

    public SipAnnotationDescriptor(ClassLoader cl, String repository) {
        loader = cl;
        classRepository = repository;
    }

    public void processAnnotations() {
        scanDirectory(new File(classRepository), null);

        for (Iterator iter = repositoryClasses.iterator(); iter.hasNext();) {
            String element = (String) iter.next();

            try {
                Class clazz = loader.loadClass(element);
                Method[] method = clazz.getMethods();

                // Loop All Methods
                for (int i = 0; i < method.length; i++) {
                    Annotation[] methodAnnotation = method[i].getDeclaredAnnotations();

                    for (int j = 0; j < methodAnnotation.length; j++) {
                        Class annotationType = methodAnnotation[j].annotationType();

                        if (annotationType.getName()
                                              .equals(SipApplicationKey.class.getName())) {
                            anno_SipApplicationKey = method[i];
                        }
                    }
                }
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void scanDirectory(File file, String pckage) {
        if (pckage == null) {
            pckage = "";
        }

        if (file.isDirectory()) {
            File[] files = file.listFiles();

            for (int i = 0; i < files.length; i++) {
                File aFile = files[i];

                if (aFile.isDirectory()) {
                    scanDirectory(aFile, pckage + aFile.getName() + ".");
                } else {
                    String fileName = aFile.getName();

                    if (fileName.endsWith(".class")) {
                        fileName = fileName.substring(0,
                                fileName.indexOf(".class"));

                        String deployedClass = pckage + fileName;
                        repositoryClasses.add(deployedClass);
                    }
                }
            }
        } else if (file.isFile()) {
            String deployedClass = pckage + file.getName();
            repositoryClasses.add(deployedClass);
        }
    }

    public boolean hasSipApplicationKey() {
        return (anno_SipApplicationKey != null) ? true : false;
    }

    public Method getSipApplicationKeyMethod() {
        return anno_SipApplicationKey;
    }

    public String invokeSipApplicationKey(SipServletRequest request)
        throws IllegalArgumentException, IllegalAccessException,
            InvocationTargetException {
        String result = "";
        result = (String) anno_SipApplicationKey.invoke(null,
                new Object[] { request });

        return result;
    }
}
