/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.annotations.ConfigurationAnnotationIntrospector;
import com.ericsson.ssa.config.event.ConfigEventMulticaster;


/**
 * ConfigFactory used to fetching an instance of the Config interface.
 *
 * @author eandbur
 * @since Apr 16, 2007
 *
 */
public class ConfigFactory extends ConfigEventMulticaster {
    private static final ConfigFactory INSTANCE = new ConfigFactory();
    private Config _config = null;

    public static ConfigFactory instance() {
        return INSTANCE;
    }

    /**
     * Fetch a instance of Config.
     *
     * @return
     */
    public static Config getConfig() {
        return INSTANCE._config;
    }

    public void registerConfig(Config config) {
        _config = config;
        _config.setEventMulticaster(this);
    }

    public void deregisterConfig() {
        if (_config != null) {
            _config.setEventMulticaster(null);
            _config = null;
        }
    }
    
    /**
     * Activate configuration for the object provided.
     * The object must be annotated with the Configuration annotation for 
     * at least one method (property setter in most cases) to be a configurable
     * else it will be ignored.
     * Note that this will keep a reference to the configurable.
     * 
     * @param configurable The object that is to be activated for configuration.
     */
    public void activateConfiguration(Object configurable) {
        ConfigurationAnnotationIntrospector.instance().activateConfiguration(configurable);
    }
    
    /**
     * Deactivate configuration for the configurable provided.
     * If the configurable was activated before it will be deactivated. Note that
     * no original value or default value is infused prior deactivation instead
     * the latest configured value remains.
     * The reference to the configurable will be removed.
     * 
     * @param configurable The object that is to be deactivated for configuration.
     */
    public void deactivateConfiguration(Object configurable) {
        ConfigurationAnnotationIntrospector.instance().activateConfiguration(configurable);
    }
}
