/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.SipSessionManager;

import org.apache.catalina.Context;


/**
 * @author epiesan
 * @since Feb 20, 2006
 */
public interface ConvergedContext extends Context {
    public static final String BEFORE_DEPLOYMENT_EVENT = "before_deployment";

    public void addAttributeToServletContext(String attributeName,
        Object attributeValue);

    public ServletDispatcher getDispatcher();

    public void setDispatcher(ServletDispatcher dispatcher);

    public SipApplication getSipApplication();

    public void setSipApplication(SipApplication sipApplication);

    public SipApplicationListeners getSipApplicationListeners();

    public void setSipApplicationListeners(
        SipApplicationListeners sipApplicationListeners);

    public SipFactoryFacade getSipFactory();

    public void setSipFactory(SipFactoryFacade sipFactory);

    /**
     * Gets the SIP session manager of this converged context.
     *
     * @return The SIP session manager of this converged context.
     */
    public SipSessionManager getSipSessionManager();

    /**
     * Sets the SIP session manager for this converged context
     *
     * @param sipSessionManager The new SIP session manager
     */
    public void setSipSessionManager(SipSessionManager sipSessionManager);
}
