/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.SipContainerAvailability;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;


/**
 * @author jluehe
 */
public class ConvergedServerConfigLookup extends ServerConfigLookup {
    /**
     * Gets the value of the persistence-type attribute of the
     * sip-container-availability element in domain.xml.
     *
     * @return The SIP persistence type, or null if not found
     */
    public PersistenceType getSipPersistenceTypeFromConfig() {
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return null;
        }

        String persistenceTypeString = sca.getPersistenceType();

        PersistenceType persistenceType = null;

        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }

        return persistenceType;
    }

    /**
     * Gets the value of the persistence-frequency attribute of the
     * sip-container-availability element in domain.xml.
     *
     * @return The SIP persistence frequency, or null if not found
     */
    public String getSipPersistenceFrequencyFromConfig() {
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return null;
        }

        return sca.getPersistenceFrequency();
    }

    /**
     * Gets the value of the persistence-scope attribute of the
     * sip-container-availability element in domain.xml.
     *
     * @return The SIP persistence scope, or null if not found
     */
    public String getSipPersistenceScopeFromConfig() {
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return null;
        }

        return sca.getPersistenceScope();
    }

    /**
     * Gets the value of the availability-enabled attribute of the
     * sip-container-availability element in domain.xml.
     *
     * @return The value of the availability-enabled attribute of the
     * sip-container-availability element in domain.xml if present,
     * otherwise the global availability-enabled
     */
    public boolean getSipContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = getAvailabilityEnabledFromConfig();
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return globalAvailabilityEnabled;
        }

        String value = sca.getAvailabilityEnabled();

        if (value == null) {
            return globalAvailabilityEnabled;
        } else {
            return ConfigBean.toBoolean(value);
        }
    }

    /**
     * Gets the value of the availability-enabled attribute of the
     * sip-container-availability element in domain.xml.
     *
     * @return The value of the availability-enabled attribute of the
     * sip-container-availability element in domain.xml if present,
     * otherwise the provided inherited value
     */
    public boolean getSipContainerAvailabilityEnabledFromConfig(
        boolean inheritedValue) {
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return inheritedValue;
        }

        String value = sca.getAvailabilityEnabled();

        if (value == null) {
            return inheritedValue;
        } else {
            return ConfigBean.toBoolean(value);
        }
    }

    /**
     * Gets the sip-container-availability element from domain.xml.
     *
     * @return The sip-container-availability element from domain.xml,
     * or.null if not found
     */
    public SipContainerAvailability getSipContainerAvailability() {
        AvailabilityService availabilityServiceBean = getAvailabilityService();

        if (availabilityServiceBean == null) {
            return null;
        }

        return availabilityServiceBean.getSipContainerAvailability();
    }

    /**
     * Determines whether availability is enabled for the given
     * SIP application, by taking the following into account:
     *
     * - Global availability from <availability-service>
     * - sip-container-availability
     * - extension-module (if stand-alone) or j2ee-application (if embedded)
     */
    public boolean calculateSipAvailabilityEnabledFromConfig(WebModule ctx) {
        // Global availability from <availability-service> element
        boolean globalAvailability = getAvailabilityEnabledFromConfig();

        boolean sipContainerAvailability = getSipContainerAvailabilityEnabledFromConfig(globalAvailability);

        boolean sipModuleAvailability = false;
        J2eeApplication j2eeApp = ctx.getApplicationBean();

        if (j2eeApp == null) {
            // The stand-alone sip module case
            ExtensionModule bean = (ExtensionModule) ctx.getBean();
            sipModuleAvailability = bean.isAvailabilityEnabled();
        } else {
            // The j2ee application case
            sipModuleAvailability = j2eeApp.isAvailabilityEnabled();
        }

        return globalAvailability && sipContainerAvailability &&
        sipModuleAvailability;
    }

    /**
     * Gets the properties under the sip-container-availability element
     * in domain.xml.
     *
     * @return The sip-container-availability properties, or an array
     * containing a single empty ElementProperty if not found
     */
    private ElementProperty[] getSipContainerAvailabilityProperties() {
        SipContainerAvailability sca = getSipContainerAvailability();

        if (sca == null) {
            return new ElementProperty[0];
        }

        return sca.getElementProperty();
    }
}
