/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.wrapper.WrapperFactorySet;

import org.jvnet.glassfish.comms.security.auth.impl.AuthInfoImpl;

import java.lang.reflect.Method;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;


/**
 * Facade for the SipFactoryImpl singelton.
 *
 * A new instance of SipFactoryFacade is bound to each context, with key
 * "javax.servlet.sip.SipFactory"
 *
 * @author lmcpepe
 */
public class SipFactoryFacade implements SipFactory {
    private static Logger logger = Logger.getLogger("SipContainer");
    private ConvergedContext m_Ctx;
    private String m_ApplicationName;
    private SipFactoryImpl m_ConcreteSipFactory;
    private SipApplication m_SipApplication;
    private SipSessionManager m_SipSessionManager;

    //////////
    private Method sessionKey = null;

    /**
     * @param sipApplication
     */
    public SipFactoryFacade(ConvergedContext ctx, SipFactoryImpl sipfactory,
        SipApplication sipApplication) {
        m_Ctx = ctx;
        m_ApplicationName = ctx.getName();
        m_SipSessionManager = ctx.getSipSessionManager();
        m_ConcreteSipFactory = sipfactory;
        m_SipApplication = sipApplication;
    }

    public SipURI createSipURI(String user, String host) {
        return m_ConcreteSipFactory.createSipURI(user, host);
    }

    public URI createURI(String uri) throws ServletParseException {
        return m_ConcreteSipFactory.createURI(uri);
    }

    public Address createAddress(String address) throws ServletParseException {
        return m_ConcreteSipFactory.createAddress(address);
    }

    public Address createAddress(URI uri) {
        return m_ConcreteSipFactory.createAddress(uri);
    }

    public Address createAddress(URI uri, String string) {
        return m_ConcreteSipFactory.createAddress(uri, string);
    }

    public Parameterable createParameterable(String s) {
        return m_ConcreteSipFactory.createParameterable(s);
    }

    public SipServletRequest createRequest(SipApplicationSession appSession,
        String method, Address from, Address to) {
        SipApplicationSession incomingSas = appSession;
        appSession = WrapperFactorySet.unwrap(appSession);

        SipServletRequestImpl request = m_ConcreteSipFactory.createRequest(appSession,
                method, from, to);
        postCreateRequest(request);

        return WrapperFactorySet.wrap(request, incomingSas);
    }

    public SipServletRequest createRequest(SipApplicationSession appSession,
        String method, URI from, URI to) {
        SipApplicationSession incomingSas = appSession;
        appSession = WrapperFactorySet.unwrap(appSession);

        SipServletRequestImpl request = m_ConcreteSipFactory.createRequest(appSession,
                method, from, to);
        postCreateRequest(request);

        return WrapperFactorySet.wrap(request, incomingSas);
    }

    public SipServletRequest createRequest(SipApplicationSession appSession,
        String method, String from, String to) throws ServletParseException {
        SipApplicationSession incomingSas = appSession;
        appSession = WrapperFactorySet.unwrap(appSession);

        SipServletRequestImpl request = m_ConcreteSipFactory.createRequest(appSession,
                method, from, to);
        postCreateRequest(request);

        return WrapperFactorySet.wrap(request, incomingSas);
    }

    public SipServletRequest createRequest(SipServletRequest origRequest,
        boolean sameCallId) {
        SipServletRequestImpl request = m_ConcreteSipFactory.createRequest(origRequest,
                sameCallId);
        postCreateRequest(request);

        return request;
    }

    public SipApplicationSession createApplicationSession() {
        SipApplicationSessionImpl as = createApplicationSessionImpl();

        if (as.isReplicable()) {
            return WrapperFactorySet.getSASFactory().wrap(as, null);
        }

        return as;
    }

    public SipApplicationSessionImpl createApplicationSessionImpl() {
        SipApplicationSessionImpl as = m_SipSessionManager.createSipApplicationSession(m_Ctx.getSipApplicationListeners());

        return as;
    }

    public void initKeyMethod(Method m) {
        sessionKey = m;
    }

    /**
     * @return Returns the m_sipApplicationListeners.
     */
    public SipApplicationListeners getSipApplicationListeners() {
        return m_Ctx.getSipApplicationListeners();
    }

    private void postCreateRequest(SipServletRequestImpl request) {
        request.setRole(m_ApplicationName);

        if (request.getSessionImpl().getHandler() == null) {
            try {
                request.getSessionImpl()
                       .setHandler(m_SipApplication.getDefaultServlet());
            } catch (ServletException ignore) {
            }
        }
    }

    // Implements the jsr289 session key lookup concept
    // Checks if there is any ref to clear and then if the SAS that we are
    // looking for is already created
    @SuppressWarnings("unchecked")
    public SipApplicationSessionImpl createApplicationSession(
        SipServletRequestImpl request) {
        if (sessionKey != null) {
            // Cleanup move to xxx
            //    if (logger.isLoggable(Level.FINE))
            //        logger.log(Level.FINE, "Cleanup Removing SAS : " + pr.get());
            //    activeSessions.remove(pr.getSessionId());
            String key = null;

            try {
                key = (String) sessionKey.invoke(null, request);
            } catch (Exception e) {
                logger.log(Level.WARNING,
                    "SessionKey for application not working!", e);
            } finally {
                if (key == null) {
                    return createApplicationSessionImpl();
                }
            }

            // There is a key now look for an existing SAS
            SipApplicationSessionImpl ref = m_SipSessionManager.findSipApplicationSession(key);

            if (ref != null) // There is a cached value to be
                             // recycled
             {
                return ref;
            }

            // Need to create a new SAS and store it
            SipApplicationSessionImpl sas = m_SipSessionManager.createSipApplicationSession(key,
                    m_Ctx.getSipApplicationListeners());

            return sas;
        }

        SipApplicationSessionImpl sas = createApplicationSessionImpl();
        sas.setBeKey(request.getBeKey());

        return sas;
    }

    public AuthInfo createAuthInfo() {
        return new AuthInfoImpl();
    }
}
