/*
 * ConfigEventMulticaster.java
 *
 * Created on August 29, 2007, 9:58 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package com.ericsson.ssa.config.event;

import com.ericsson.ssa.config.ConfigRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 *
 * @author ELNELBO
 */
public class ConfigEventMulticaster implements ConfigEventRegistry {
    protected Map<ConfigChangeListener, List<String>> registry = new HashMap<ConfigChangeListener, List<String>>();

    /**
     * Creates a new instance of ConfigEventMulticaster
     */
    public ConfigEventMulticaster() {
    }

    public synchronized void registerConfigChangeListener(String nodePattern,
        ConfigChangeListener listener) {
        if (registry.containsKey(listener)) {
            List<String> patterns = registry.get(listener);
            patterns.add(nodePattern);
            registry.put(listener, patterns);
        } else {
            List<String> patterns = new ArrayList<String>(1);
            patterns.add(nodePattern);
            registry.put(listener, patterns);
        }
    }

    public synchronized void deregisterConfigChangeListener(ConfigChangeListener listener) {
        registry.remove(listener);
    }

    public void processEvent(ConfigEvent event) {
        Map<ConfigChangeListener, List<String>> registryClone = null;
        synchronized(registry) {
            registryClone = new HashMap<ConfigChangeListener, List<String>>(registry);
        }
        
        ConfigRuntimeException troubles = null;
        for (Map.Entry<ConfigChangeListener, List<String>> entry : registryClone.entrySet()) {
            for (String pattern : entry.getValue()) {
                if (match(pattern, event)) {
                    System.out.println("processEvent    match :) for " +
                        event.getClass().getName() + " with " + pattern +
                        " and " + event.getNode());

                    try {
                        if (event instanceof ConfigAddEvent) {
                            entry.getKey().handleConfigEvent((ConfigAddEvent) event);
                        }

                        if (event instanceof ConfigUpdateEvent) {
                            entry.getKey().handleConfigEvent((ConfigUpdateEvent) event);
                        }

                        if (event instanceof ConfigRemoveEvent) {
                            entry.getKey().handleConfigEvent((ConfigRemoveEvent) event);
                        }
                    } catch(Exception e) {
                        //This catch may be to wide!
                        //Each listener gets the opertunaty to handle the event.
                        //It lokalizes the effect of troublesome listeners.
                        if (troubles==null) {
                            troubles = new ConfigRuntimeException("Muticasting event ["+
                                    event.getNode()+"] failed for atleast one listener");
                        }
                        troubles.addCause(e);
                    }
                } else {
                    System.out.println("processEvent no match :( for " +
                        event.getClass().getName() + " with " + pattern +
                        " and " + event.getNode());
                }
            }
        }
        if (troubles!=null) {
            throw troubles;
        }
    }

    protected boolean match(String nodePattern, ConfigEvent event) {
        return event.getNode().matches(nodePattern);
    }
}
