/*
* The contents of this file are subject to the terms
* of the Common Development and Distribution License
* (the License).  You may not use this file except in
* compliance with the License.
*
* You can obtain a copy of the license at
* https://glassfish.dev.java.net/public/CDDLv1.0.html or
* glassfish/bootstrap/legal/CDDLv1.0.txt.
* See the License for the specific language governing
* permissions and limitations under the License.
*
* When distributing Covered Code, include this CDDL
* Header Notice in each file and include the License file
* at glassfish/bootstrap/legal/CDDLv1.0.txt.
* If applicable, add the following below the CDDL Header,
* with the fields enclosed by brackets [] replaced by
* you own identifying information:
* "Portions Copyrighted [year] [name of copyright owner]"
*
* Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
* Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
*/

package com.ericsson.ssa.container.callflow;


import org.jvnet.glassfish.comms.util.LogUtil;



public class CallflowResolver {
    
    private static CallflowResolver _instance = new CallflowResolver();
    
    LogUtil log = LogUtil.SIP_LOGGER;
    
    private String REPORTER_PACKAGE = "org.jvnet.glassfish.comms.admin.callflow.reporter";


    public static CallflowResolver getInstance(){
        return _instance;
    }
    
    public Reporter getReporter(String reporterString){
        if(reporterString != null)
            return getReporter(reporterString.split(","));
        return null;
    }
    
    private Reporter getReporter(String[] reporters){
        if(reporters.length == 1){
            return reporterForString(reporters[0]);
        }
        else {
            ComplexReporter combined = new ComplexReporter();
            for(String name: reporters) {
                Reporter r = reporterForString(name);
                combined.addReporter(r);
            }
            if( combined.countReporters() > 0 )
                return combined;
            return null;
        }
    }
    
    private Reporter reporterForString(String name) {
        String className = REPORTER_PACKAGE + "." + name;
        try {
            Class<?> reporterClass = Class.forName(className);
            Object obj = reporterClass.newInstance();
            if( obj instanceof Reporter ){
                if(log.logInfo())
                    log.infoMsg("Loaded callflow reporter " + className);
                return (Reporter)obj;            
            }
        } catch (InstantiationException ex) {
            log.warning("com.ericsson.ssa.container.callflow.CallflowResolver.instantiation_error", className);
        } catch (IllegalAccessException ex) {
            log.warning("com.ericsson.ssa.container.callflow.CallflowResolver.access_error", className);
        } catch (ClassNotFoundException ex) {
            log.warning("com.ericsson.ssa.container.callflow.CallflowResolver.class_error", className);
        }
        return null;
    }
    
}
