/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.datacentric;

import com.sun.enterprise.server.ApplicationServer;


/**
 * This is a utility for accessing and querying the Data Centric entities, for example the
 * consistent hash for all server instances in the cluster.
 * <p>
 * This is an abstract singleton for which the concrete implementation should be provided at
 * start-up of the container.
 *
 */
public abstract class DataCentricUtil {
    private static DataCentricUtil instance = new DefaultInstance(); // The instance

    protected DataCentricUtil() {
    }

    /**
     * Sets the instance.
     * @param instance a concrete implementation of this class.
     */
    public static void setInstance(DataCentricUtil instance) {
        DataCentricUtil.instance = instance;
    }

    /**
     * Gets the instance.
     * @return
     */
    public static DataCentricUtil getInstance() {
        return instance;
    }

    /**
     * Gets the actual server instance (i.e, with regard to the actual cluster shape) that 
     * is mapped to the specified key.
     * @param key the key
     * @return the server instance that is mapped to the specified key
     */
    public abstract String getActualServerInstance(String key);

    /**
     * Gets the server instance that would be mapped to the specified key in case the cluster 
     * is complete (i.e. all servers are working).
     * @param key the key
     * @return the ideal server instance that is mapped to the specified key
     */
    public abstract String getIdealServerInstance(String key);

    /**
     * Checks if the specified key should be handled by the current (local) instance.
     * @param key the key
     * @return true if the key is mapped to the local server instance; otherwise false
     */
    public abstract boolean isLocal(String key);
    
    private static class DefaultInstance extends DataCentricUtil {

        @Override
        public String getActualServerInstance(String key) {
            return ApplicationServer.getServerContext().getInstanceName();
        }

        @Override
        public String getIdealServerInstance(String key) {
            return ApplicationServer.getServerContext().getInstanceName();
        }

        @Override
        public boolean isLocal(String key) {
            return true;
        }
        
    }
}
