/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


public class ContainsOperand extends Operand {
    /**
          * serialViersion
          */
    private static final long serialVersionUID = 1L;

    /**
    * Specifies a variable
    */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Specifies whether the "contains" test is case sensitive or not
     */
    private boolean ignoreCase = false;

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the value of the variable contains the specified literal
     *         value
     */
    public boolean evaluate(Object object) {
        String attribute = getAttributeValue(variable,
                (SipServletRequest) object);

        if (attribute == null) // Incase of getAttributeValue return null.
         {
            return false;
        }

        String compareAttribute = attribute;
        String compareValue = value;

        if (ignoreCase) {
            compareAttribute = attribute.toLowerCase();
            compareValue = value.toLowerCase();
        }

        return (compareAttribute.indexOf(compareValue) != -1);
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * Called by the digester with string value of true or false.
     * @param ignoreCase
     */
    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = Boolean.parseBoolean(ignoreCase);
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Returns the value of ignore case.
     * @return boolean if ignore case is false or true.
     */
    public boolean isIgnoreCase() {
        return ignoreCase;
    }
}
