/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collection;


public class SecurityConstraint implements Serializable {
    private static final long serialVersionUID = 3689355416056115506L;
    private String displayName;
    private Collection<ResourceCollection> resourceCollections;
    private boolean proxyAuthenticated;
    private String authorizationConstraintDescription;
    private Collection<String> authorizationConstraintRoleNames;
    private String userDataConstraintDescription;
    private String userDataTransportGuarantee;

    /**
     *
     *
     *
     */
    public SecurityConstraint() {
        resourceCollections = new ArrayList<ResourceCollection>();
    }

    /**
     * @param resourceCollection
     */
    public void addResourceCollection(ResourceCollection resourceCollection) {
        resourceCollections.add(resourceCollection);
    }

    /**
     * @param roleName
     */
    public void addAuthorizationConstraintRoleNames(String roleName) {
        if (authorizationConstraintRoleNames == null) {
            authorizationConstraintRoleNames = new ArrayList<String>();
        }

        authorizationConstraintRoleNames.add(roleName);
    }

    /**
     * @return
     */
    public Collection getResourceCollections() {
        return resourceCollections;
    }

    /**
     * @return
     */
    public Collection<String> getAuthorizationConstraintRoleNames() {
        return authorizationConstraintRoleNames;
    }

    /**
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public boolean isProxyAuthenticated() {
        return proxyAuthenticated;
    }

    /**
     *
     *
     *
     */
    public void setProxyAuthenticated(String ignore) {
        this.proxyAuthenticated = true;
    }

    /**
     * @return
     */
    public String getUserDataConstraintDescription() {
        return userDataConstraintDescription;
    }

    /**
     * @param userDataConstraintDescription
     */
    public void setUserDataConstraintDescription(
        String userDataConstraintDescription) {
        this.userDataConstraintDescription = userDataConstraintDescription;
    }

    /**
     * @return
     */
    public String getUserDataTransportGuarantee() {
        return userDataTransportGuarantee;
    }

    /**
     * @param userDataTransportGuarantee
     */
    public void setUserDataTransportGuarantee(String userDataTransportGuarantee) {
        if (!TransportGuarantee.contains(userDataTransportGuarantee)) {
            throw new RuntimeException("Values for transport guarantee must " +
                "be of " + TransportGuarantee.printNames());
        }

        this.userDataTransportGuarantee = userDataTransportGuarantee;
    }

    /**
     * @return
     */
    public String getAuthorizationConstraintDescription() {
        return authorizationConstraintDescription;
    }

    /**
     * @param authorizationConstraintDescription
     */
    public void setAuthorizationConstraintDescription(
        String authorizationConstraintDescription) {
        this.authorizationConstraintDescription = authorizationConstraintDescription;
    }
}
