/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import java.net.URL;


public class SipEntityResolver implements EntityResolver {
    private static final String SIP_DTD_FILE = "com/ericsson/ssa/dd/sip-app_1_0.dtd";
    private boolean validate = true;

    /**
     * This function returns an InputSource of the DTD file specified by the
     * systemId argument. Because the net may not be available in some system
     * configuration, when validation is turned on, we first try to load the DTD
     * file from the configuration directory of EAS. If the file is not found, we
     * return an invalid InputSource. Returning null or an invalid InputSource
     * (an InputSource initialized with a null InputStream) will let the parser
     * itself load the DTD file. We return a dummy DTD file when the validation
     * is turned off. This will stop the parser from trying to load the DTD file.
     *
     * @param publicId -
     *        The public identifier of the external entity being referenced, or
     *        null if none was supplied.
     * @param systemId -
     *        The system identifier of the external entity being referenced.
     * @return InputSource - An InputSource object describing the new input
     *         source, or null to request that the parser open a regular URI
     *         connection to the system identifier.
     * @exception org.xml.sax.SAXException -
     *            Any SAX exception, possibly wrapping another exception.
     * @exception java.io.IOException -
     *            A Java-specific IO exception, possibly the result of creating a
     *            new InputStream or Reader for the InputSource.
     * @see org.xml.sax.InputSource
     */
    public InputSource resolveEntity(String publicId, String systemId)
        throws SAXException, IOException {
        if (this.validate == false) {
            return new InputSource(new ByteArrayInputStream(
                    (new String("<!-- -->")).getBytes()));
        }

        InputStream inputStream = null;
        URL sipDtdFile = SipEntityResolver.class.getClassLoader()
                                                .getResource(SIP_DTD_FILE);
        inputStream = sipDtdFile.openStream();

        return new InputSource(inputStream);
    }
}
