/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.router;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;

import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipApplicationRoutingRegion;
import javax.servlet.sip.SipRouteModifier;
import javax.servlet.sip.SipServletReadOnlyRequest;

import org.jvnet.glassfish.comms.util.LogUtil;


public class AlphabeticalRouter implements SipApplicationRouter {
    private SortedSet<String> deployedApps = new TreeSet<String>();
    
	private static LogUtil theirLog = LogUtil.AR_LOGGER;
	private static final String LOGPREFIX = 
		"com.ericsson.ssa.router.AlphabeticalRouter.";

    public void init() {
    	if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "initempty");
        }
    	deployedApps = new TreeSet<String>();
}
    
    public void init(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "init");
        }

        deployedApps = new TreeSet<String>(applications);
    }

    public void destroy() {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "destroy");
        }

        deployedApps = null;
    }

    public void applicationDeployed(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "applications_deployed");
        }

        for (String app : applications) {
            if (!deployedApps.contains(app)) {
                if (theirLog.isLoggable(Level.FINE)) {
            		theirLog.log(Level.FINE, LOGPREFIX + "application_added", app);
                }

                deployedApps.add(app);
            } else {
                if (theirLog.isLoggable(Level.FINE)) {
            		theirLog.log(Level.FINE, LOGPREFIX + "application_upgraded", app);
                }
            }
        }
    }

    public void applicationUndeployed(List<String> applications) {
        if (theirLog.isLoggable(Level.FINE)) {
    		theirLog.log(Level.FINE, LOGPREFIX + "applications_undeployed");
        }

        for (String app : applications) {
            boolean removed = deployedApps.remove(app);

            if (theirLog.isLoggable(Level.FINE)) {
        		theirLog.log(Level.FINE, LOGPREFIX + "application_removed", app, removed);
            }
        }
    }

    /*
     * Only checks the state info since each request is traversed by all
     * applications in the alphabetical order
     */

	public SipApplicationRouterInfo getNextApplication(
			SipServletReadOnlyRequest initialRequest,
			SipApplicationRoutingRegion region,
			SipApplicationRoutingDirective directive, Serializable stateInfo) {
		
        if (theirLog.isLoggable(Level.FINEST)) {
    		theirLog.log(Level.FINEST, LOGPREFIX + "getnextapp", 
				initialRequest, region, directive, stateInfo);
        }
        			
        SipApplicationRouterInfo info = null;
        String subscriberURI = 
        	initialRequest.getRequestURI().toString();

        String app = null;

        if (stateInfo == null) { 
        	// First invocation of AlphabeticalRouter
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, "stateinfonull");
        	}
            if (deployedApps != null) {
                try {
                    app = deployedApps.first();
                } catch (RuntimeException re) {
                 	theirLog.log(Level.SEVERE, "firstapperror", re.getMessage());              
             	}
        	}
        } else {
            boolean match = false;

            for (String x : deployedApps) {
                if (match) {
                    app = x;
                	if (theirLog.isLoggable(Level.FINEST)) {
                   		theirLog.log(Level.FINEST, LOGPREFIX + "nextappfound", x); 
                	}
                    break;
                }

                if (stateInfo.equals(x)) {
                    match = true;
                }
            }
        }

        if (app == null) {
        	// No application found, time to leave the container.
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, LOGPREFIX + "noappfound");
        	}
        	
            SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;

            info = new SipApplicationRouterInfo(
            		null, // next application name, external so null
            		null, // routing region, external so null
            		null, // served subscriber URI, external so null
            		null, // route, modifier set to NO_ROUTE so irrelevant
            		modifier, 
            		null); // stateinfo TODO should we pass existing state info?
        } else { 
        	if (theirLog.isLoggable(Level.FINEST)) {
             	theirLog.log(Level.FINEST, LOGPREFIX + "routinginternally");
        	}
        	
        	// Internal application selected. The route modifier is set to 
        	// NO_ROUTE. This means (JSR289) the container should disregard
        	// the route in the info object and inspect the app name instead.
            SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;
            info = new SipApplicationRouterInfo(
        		app, // next application name
        		region, // region in which app will serve, use unchanged
        		subscriberURI, // just use what came in
        		null, // route, modifier set to NO_ROUTE so irrelevant
        		modifier,
                app ); // application name used as stateinfo
        }

        return info;
    }

	public void configurationChanged(InputStream configInputStream) {
		// TODO Auto-generated method stub
	}
}
