/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

import javax.servlet.sip.Address;

import com.sun.enterprise.server.ApplicationServer;


/**
 * TODO Add comments (class description)
 *
 * @author ehsroha
 * @since 2005-maj-26
 */
public class DialogSet{
    /**
     *
     */
    private static final long serialVersionUID = -6352106202257349396L;
    private final Ascii7String m_CallId;
    private final Address m_From;
    private final Queue<DialogFragment> m_Dialogs = new ConcurrentLinkedQueue<DialogFragment>();
    private final AtomicInteger m_DialogSetFragmentId = new AtomicInteger(0);
    private final DialogFragment m_InitialDialogFragment;

    private boolean m_IsEarlyDialogValid = true;

    /**
     * creates a DialogSet including the initial DialogFragment
     *
     */
    public DialogSet(String callId, Address from) {
        m_CallId = new Ascii7String(callId);
        m_From = from;
        
        m_InitialDialogFragment = DialogFragmentManager.getInstance().createDialogFragment(this);
        addDialog(m_InitialDialogFragment);
    }

    public DialogFragment getInitialDialogFragment(){
    	return m_InitialDialogFragment;
    }
    
    public DialogFragment createAdditionalDialogFragment() {
    	DialogFragment df = DialogFragmentManager.getInstance().createDialogFragment(this);
        addDialog(df);
        return df;
    }

    public static String createKey(String callId, String fromTag) {
        return DialogFragment.createKey(callId, fromTag, null, null);
    }

    public String getCallId() {
        return m_CallId.toString();
    }
    
    public Ascii7String getCallIdAscii7String() {
        return m_CallId;
    }

    public Address getFrom() {
        return m_From;
    }

    /**
     * @return the from tag of this Dialog.
     */
    public String getFromTag() {
        return getFrom().getParameter(AddressImpl.TAG_PARAM);
    }

    private void addDialog(DialogFragment d) {
        m_Dialogs.add(d);
    }

    public void removeDialog(DialogFragment d) {
        m_Dialogs.remove(d);
        removeEarlyDialog();
    }

    public void removeEarlyDialog() {
        if (m_IsEarlyDialogValid) {
            synchronized (this) {
                if (m_IsEarlyDialogValid) {
                    SessionManager.getInstance().removeEarlyDialog(this);
                    m_IsEarlyDialogValid = false;
                }
            }
        }
    }

    public DialogFragment getDialog(String fragmentId) {
    	if (fragmentId.equals(DialogFragment.DEFAULT_FRAGMENT_ID)) {
    		return  m_InitialDialogFragment;
    	}
        for (DialogFragment d : m_Dialogs) {
            if (fragmentId == d.getFragmentId()) {
                // match, lets return it...
                return d;
            }
        }

        // no match...
        return null;
    }

    public Iterator<DialogFragment> getDialogs() {
        return m_Dialogs.iterator();
    }

    public DialogFragment searchForDialog(String toTag, String fragmentId) {
    	if (fragmentId.equals(DialogFragment.DEFAULT_FRAGMENT_ID)) {
    		throw new IllegalStateException("This method should not be used to search via the DEFAULT_FRAGMENT_ID");
    	}
    	// TODO Maybe we should iterate over m_Dialogs
    	// instead of via DialogFragmentManager
        String key = DialogFragment.createKey(m_CallId.toString(),
                getFromTag(), toTag, fragmentId);

        return DialogFragmentManager.getInstance().findDialogFragment(key);
    }

    /**
     * Needed for creational NOTIFY
     *
     * @param fragmentId
     * @return a cloned DialogFragment matching the fragmentId or null otherwise
     */
    public DialogFragment cloneDialog(String fragmentId) {
    	if (fragmentId.equals(DialogFragment.DEFAULT_FRAGMENT_ID)) {
    		return (DialogFragment) m_InitialDialogFragment.clone();
    	}
        for (DialogFragment d : m_Dialogs) {
            if (d.getFragmentId().equals(fragmentId)) {
                // match, lets return a clone...
                return (DialogFragment) d.clone();
            }
        }

        // no match...
        return null;
    }
    
    public String nextFragmentId() {
    	String instanceId = ApplicationServer.getServerContext().getInstanceName();
    	return instanceId+"_"+m_DialogSetFragmentId.incrementAndGet();	
    }    
}
