/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.io.UnsupportedEncodingException;

import java.util.logging.Level;

import javax.servlet.sip.URI;


/**
 * This will represent misc. URI like mailto or http.
 *
 * @author eraayaz
 * @since 2006-jan-03
 *
 */

// public class GeneralURIImpl implements URI
public class GeneralURIImpl extends URIImpl {
    private String _scheme = null;
    private String _uri = null;

    //private static final Logger _logger = Logger.getLogger("SipContainer");
    public GeneralURIImpl(String scheme, String uri) {
        _scheme = scheme;
        _uri = uri;
    }

    public GeneralURIImpl(String scheme, byte[] bytes, int offset) {
        _scheme = scheme;

        //int len = scheme.length();
        try {
            _uri = new String(bytes, offset, bytes.length - offset,
                    SipFactoryImpl.SIP_CHARSET);
        } catch (UnsupportedEncodingException e) {
        }
    }

    /* (non-Javadoc)
     * @see javax.servlet.sip.URI#getScheme()
     */
    public String getScheme() {
        return _scheme;
    }

    /* (non-Javadoc)
     * @see javax.servlet.sip.URI#isSipURI()
     */
    public boolean isSipURI() {
        return false;
    }

    /* (non-Javadoc)
     * @see javax.servlet.sip.URI#clone()
     */
    public Object clone() {
        GeneralURIImpl clone = new GeneralURIImpl(_scheme, _uri);

        return clone;
    }

    public String toString() {
        return _scheme + ":" + _uri;
    }
}
