/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;


/**
 * Since the container uses lazy parsing every component in the container
 * should throw this exception whenever it notices that something is wrong.
 * in most cases it will be due to catching an exception.
 * If that is not the case it is recomended that the component tries to answer
 * using the normal stack layer chain.
 * This is a last effort and it will answe in the network layer with a 4xx response.
 * So the recommendation is to only set the code to 4XX
 *
 * @author ekrigro
 * @since 2005-maj-11
 *
 */
public class LazyParsingException extends RuntimeException {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    private int _sipErrorCode = 400;
    private String _reasonPhrase = null;

    public LazyParsingException(int code, String reason) {
        super(reason);
        _reasonPhrase = reason;
        _sipErrorCode = code;
    }

    public LazyParsingException(int code, Throwable exception) {
        super(exception);
        _sipErrorCode = code;
    }

    public LazyParsingException(int code, String reason, Throwable exception) {
        super(reason, exception);
        _reasonPhrase = reason;
        _sipErrorCode = code;
    }

    public LazyParsingException(Throwable exception) {
        super(exception);

        // TODO Auto-generated constructor stub
    }

    public int getSipErrorCode() {
        return _sipErrorCode;
    }

    public String getReasonPhrase() {
        return _reasonPhrase;
    }
}
