/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */

 package com.ericsson.ssa.sip;

import javax.servlet.sip.Proxy;

/**
 * Interface for a Proxy object. 
 * 
 * @author qmaghes
 *
 */
public interface ProxyInterface {

	/**
	 * Proxy dispatches a request
	 * 
	 * @param req
	 * @param context
	 */
	public void dispatch(SipServletRequestImpl req, ProxyContext context);

	/**
	 * Proxy dispatches a response
	 * 
	 * @param req
	 * @param context
	 */
	public void dispatch(SipServletResponseImpl resp, ProxyContext context);

	/**
	 * Get a javax.servlet.sip.Proxy object 
	 * 
	 * @param request
	 * @return
	 */
	public Proxy getFacade(SipServletRequestImpl request);

	/**
	 * Set virtual proxy branch request
	 * 
	 * @param resp
	 */
	public void setVirtualProxyBranchRequest(SipServletResponseImpl resp);

	/**
	 * Start virtual proxy branch
	 * 
	 * @param resp
	 */
	public void startVirtualProxyBranch(SipServletResponseImpl resp);

	/**
	 * Get a confirmed proxy object
	 * 
	 * 
	 * @return
	 */
	public ProxyInterface asConfirmed();
}
