/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.datacentric.DataCentricUtil;

public class SipApplicationSessionUtil {

    private static final DataCentricUtil dataCentricUtil =
        DataCentricUtil.getInstance();

    /**
     * Gets the actual server instance (i.e, with respect to the actual
     * cluster shape) to which the given SipApplicationSession id currently
     * maps.
     *
     * @param sasId the SipApplicationSession id to be mapped
     *
     * @return the server instance to which the specified 
     * SipApplicationSession id currently maps
     */
    public static String getActualServerInstance(String sasId) {
        return dataCentricUtil.getActualServerInstance(
            getSipApplicationKey(sasId));
    }

    /**
     * Gets the server instance to which the specified SipApplicationSession
     * id would map if the cluster were complete (i.e., if all cluster
     * instances were up).
     *
     * @param sasId the SipApplicationSession id to be mapped
     *
     * @return the ideal server instance to which the specified 
     * SipApplicationSession id would map if all cluster instances were up
     */
    public static String getIdealServerInstance(String sasId) {
        return dataCentricUtil.getIdealServerInstance(
            getSipApplicationKey(sasId));
    }

    /**
     * Checks if the specified SipApplicationSession id maps to the current
     * (local) instance.
     *
     * @param sasId the SipApplicationSession id 
     *
     * @return true if the given SipApplicationSession id maps to the local
     * server instance; false otherwise
     */
    public static boolean isLocal(String sasId) {
        return dataCentricUtil.isLocal(getSipApplicationKey(sasId));
    }

    /**
     * Returns the SIP application key portion of the given
     * SipApplicationSession id.
     *
     * @param sasId the SipApplicationSession id
     *
     * @return the SIP application key
     */
    public static String getSipApplicationKey(String sasId) {
        // FIXME
        return sasId;
    }

}
